/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.model.generated;

import org.melati.poem.AccessPoemException;
import org.melati.poem.Column;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.DisplayLevel;
import org.melati.poem.Field;
import org.melati.poem.JdbcPersistent;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.SQLPoemType;
import org.melati.poem.Searchability;
import org.melati.poem.StringPoemType;
import org.melati.poem.Table;
import org.melati.poem.TroidPoemType;
import org.melati.poem.ValidationPoemException;
import org.paneris.melati.boards.model.AttachmentType;
import org.paneris.melati.boards.model.BoardsDatabaseTables;
import org.paneris.melati.boards.model.BoardsTable;

public class AttachmentTypeTableBase<T extends AttachmentType>
extends BoardsTable<T> {
    private Column<Integer> col_id = null;
    private Column<String> col_type = null;

    public AttachmentTypeTableBase(Database database, String name, DefinitionSource definitionSource) throws PoemException {
        super(database, name, definitionSource);
    }

    public BoardsDatabaseTables getBoardsDatabaseTables() {
        return (BoardsDatabaseTables)this.getDatabase();
    }

    public void init() throws PoemException {
        super.init();
        this.col_id = new Column<Integer>((Table)this, "id", (SQLPoemType)new TroidPoemType(), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((AttachmentType)g).getId();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((AttachmentType)g).setId((Integer)cooked);
            }

            public Field<Integer> asField(Persistent g) {
                return ((AttachmentType)g).getIdField();
            }

            public boolean defaultUserEditable() {
                return false;
            }

            public boolean defaultUserCreateable() {
                return false;
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Integer defaultDisplayOrderPriority() {
                return new Integer(0);
            }

            public int defaultDisplayOrder() {
                return 0;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((AttachmentType)g).getId_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((AttachmentType)g).setId_unsafe((Integer)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((AttachmentType)g).getId();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((AttachmentType)g).setId((Integer)raw);
            }
        };
        this.defineColumn((Column)this.col_id);
        this.col_type = new Column<String>((Table)this, "type", (SQLPoemType)new StringPoemType(false, -1), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((AttachmentType)g).getType();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((AttachmentType)g).setType((String)cooked);
            }

            public Field<String> asField(Persistent g) {
                return ((AttachmentType)g).getTypeField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.primary;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public int defaultDisplayOrder() {
                return 1;
            }

            public String defaultDescription() {
                return "The name of a type";
            }

            public boolean defaultUnique() {
                return true;
            }

            public int defaultWidth() {
                return 40;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((AttachmentType)g).getType_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((AttachmentType)g).setType_unsafe((String)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((AttachmentType)g).getType();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((AttachmentType)g).setType((String)raw);
            }
        };
        this.defineColumn((Column)this.col_type);
    }

    public final Column<Integer> getIdColumn() {
        return this.col_id;
    }

    public final Column<String> getTypeColumn() {
        return this.col_type;
    }

    public AttachmentType getAttachmentTypeObject(Integer troid) {
        return (AttachmentType)this.getObject(troid);
    }

    public AttachmentType getAttachmentTypeObject(int troid) {
        return (AttachmentType)this.getObject(troid);
    }

    protected JdbcPersistent _newPersistent() {
        return new AttachmentType();
    }

    public String defaultDisplayName() {
        return "Attachment Type";
    }

    public String defaultDescription() {
        return "A type of an attachment";
    }

    public boolean defaultRememberAllTroids() {
        return true;
    }

    public Integer defaultCacheLimit() {
        return new Integer(999999999);
    }

    public String defaultCategory() {
        return "Boards";
    }

    public int defaultDisplayOrder() {
        return 1060;
    }

    public AttachmentType ensure(String type) {
        AttachmentType p = (AttachmentType)this.getTypeColumn().firstWhereEq((Object)type);
        if (p == null) {
            p = (AttachmentType)this.newPersistent();
            p.setType(type);
        }
        return (AttachmentType)this.getTypeColumn().ensure((Persistent)p);
    }
}

