/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.model.generated;

import org.melati.poem.AccessPoemException;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.Column;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.DisplayLevel;
import org.melati.poem.Field;
import org.melati.poem.JdbcPersistent;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.ReferencePoemType;
import org.melati.poem.SQLPoemType;
import org.melati.poem.Searchability;
import org.melati.poem.StringPoemType;
import org.melati.poem.Table;
import org.melati.poem.TroidPoemType;
import org.melati.poem.ValidationPoemException;
import org.paneris.melati.boards.model.Board;
import org.paneris.melati.boards.model.BoardType;
import org.paneris.melati.boards.model.BoardsDatabaseTables;
import org.paneris.melati.boards.model.BoardsTable;

public class BoardTableBase<T extends Board>
extends BoardsTable<T> {
    private Column<Integer> col_id = null;
    private Column<Integer> col_type = null;
    private Column<String> col_name = null;
    private Column<String> col_displayname = null;
    private Column<String> col_purpose = null;
    private Column<Boolean> col_archived = null;
    private Column<Boolean> col_opensubscription = null;
    private Column<Boolean> col_moderatedsubscription = null;
    private Column<Boolean> col_openposting = null;
    private Column<Boolean> col_moderatedposting = null;
    private Column<Boolean> col_openmessageviewing = null;
    private Column<Boolean> col_openmemberlist = null;
    private Column<Boolean> col_attachmentsallowed = null;
    private Column<Boolean> col_anonymousposting = null;
    private Column<String> col_attachmentspath = null;
    private Column<String> col_attachmentsurl = null;

    public BoardTableBase(Database database, String name, DefinitionSource definitionSource) throws PoemException {
        super(database, name, definitionSource);
    }

    public BoardsDatabaseTables getBoardsDatabaseTables() {
        return (BoardsDatabaseTables)this.getDatabase();
    }

    public void init() throws PoemException {
        super.init();
        this.col_id = new Column<Integer>((Table)this, "id", (SQLPoemType)new TroidPoemType(), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Board)g).getId();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Board)g).setId((Integer)cooked);
            }

            public Field<Integer> asField(Persistent g) {
                return ((Board)g).getIdField();
            }

            public boolean defaultUserEditable() {
                return false;
            }

            public boolean defaultUserCreateable() {
                return false;
            }

            public int defaultDisplayOrder() {
                return 0;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Board)g).getId_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setId_unsafe((Integer)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Board)g).getId();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setId((Integer)raw);
            }
        };
        this.defineColumn((Column)this.col_id);
        this.col_type = new Column<Integer>((Table)this, "type", (SQLPoemType)new ReferencePoemType(this.getBoardsDatabaseTables().getBoardTypeTable(), false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Board)g).getType();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Board)g).setType((BoardType)((Object)cooked));
            }

            public Field<Integer> asField(Persistent g) {
                return ((Board)g).getTypeField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.summary;
            }

            public Searchability defaultSearchability() {
                return Searchability.primary;
            }

            public Integer defaultDisplayOrderPriority() {
                return new Integer(0);
            }

            public int defaultDisplayOrder() {
                return 1;
            }

            public String defaultDescription() {
                return "The type of this messageboard";
            }

            public boolean defaultIndexed() {
                return true;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Board)g).getType_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setType_unsafe((Integer)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Board)g).getTypeTroid();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setTypeTroid((Integer)raw);
            }
        };
        this.defineColumn((Column)this.col_type);
        this.col_name = new Column<String>((Table)this, "name", (SQLPoemType)new StringPoemType(false, -1), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Board)g).getName();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Board)g).setName((String)cooked);
            }

            public Field<String> asField(Persistent g) {
                return ((Board)g).getNameField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.summary;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public Integer defaultDisplayOrderPriority() {
                return new Integer(1);
            }

            public String defaultDisplayName() {
                return "Name";
            }

            public int defaultDisplayOrder() {
                return 2;
            }

            public String defaultDescription() {
                return "A code-name for this board";
            }

            public boolean defaultUnique() {
                return true;
            }

            public int defaultWidth() {
                return 40;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Board)g).getName_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setName_unsafe((String)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Board)g).getName();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setName((String)raw);
            }
        };
        this.defineColumn((Column)this.col_name);
        this.col_displayname = new Column<String>((Table)this, "displayname", (SQLPoemType)new StringPoemType(false, -1), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Board)g).getDisplayname();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Board)g).setDisplayname((String)cooked);
            }

            public Field<String> asField(Persistent g) {
                return ((Board)g).getDisplaynameField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.primary;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public int defaultDisplayOrder() {
                return 3;
            }

            public String defaultDescription() {
                return "A user-friendly name of this board";
            }

            public boolean defaultUnique() {
                return true;
            }

            public int defaultWidth() {
                return 40;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Board)g).getDisplayname_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setDisplayname_unsafe((String)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Board)g).getDisplayname();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setDisplayname((String)raw);
            }
        };
        this.defineColumn((Column)this.col_displayname);
        this.col_purpose = new Column<String>((Table)this, "purpose", (SQLPoemType)new StringPoemType(true, -1), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Board)g).getPurpose();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Board)g).setPurpose((String)cooked);
            }

            public Field<String> asField(Persistent g) {
                return ((Board)g).getPurposeField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Searchability defaultSearchability() {
                return Searchability.no;
            }

            public int defaultDisplayOrder() {
                return 4;
            }

            public String defaultDescription() {
                return "The purpose of this message board";
            }

            public int defaultWidth() {
                return 40;
            }

            public int defaultHeight() {
                return 6;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Board)g).getPurpose_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setPurpose_unsafe((String)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Board)g).getPurpose();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setPurpose((String)raw);
            }
        };
        this.defineColumn((Column)this.col_purpose);
        this.col_archived = new Column<Boolean>((Table)this, "archived", (SQLPoemType)new BooleanPoemType(false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Board)g).getArchived();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Board)g).setArchived((Boolean)cooked);
            }

            public Field<Boolean> asField(Persistent g) {
                return ((Board)g).getArchivedField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Searchability defaultSearchability() {
                return Searchability.no;
            }

            public int defaultDisplayOrder() {
                return 5;
            }

            public String defaultDescription() {
                return "If a board is archived then it cannot be viewed and is not displayed on lists by default";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Board)g).getArchived_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setArchived_unsafe((Boolean)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Board)g).getArchived();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setArchived((Boolean)raw);
            }
        };
        this.defineColumn((Column)this.col_archived);
        this.col_opensubscription = new Column<Boolean>((Table)this, "opensubscription", (SQLPoemType)new BooleanPoemType(false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Board)g).getOpensubscription();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Board)g).setOpensubscription((Boolean)cooked);
            }

            public Field<Boolean> asField(Persistent g) {
                return ((Board)g).getOpensubscriptionField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public String defaultDisplayName() {
                return "Open Subscription";
            }

            public int defaultDisplayOrder() {
                return 6;
            }

            public String defaultDescription() {
                return "With open subscription anyone can subscribe to the board. Otherwise a board manager must subscribe members";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Board)g).getOpensubscription_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setOpensubscription_unsafe((Boolean)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Board)g).getOpensubscription();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setOpensubscription((Boolean)raw);
            }
        };
        this.defineColumn((Column)this.col_opensubscription);
        this.col_moderatedsubscription = new Column<Boolean>((Table)this, "moderatedsubscription", (SQLPoemType)new BooleanPoemType(false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Board)g).getModeratedsubscription();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Board)g).setModeratedsubscription((Boolean)cooked);
            }

            public Field<Boolean> asField(Persistent g) {
                return ((Board)g).getModeratedsubscriptionField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public String defaultDisplayName() {
                return "Moderated Subscription";
            }

            public int defaultDisplayOrder() {
                return 7;
            }

            public String defaultDescription() {
                return "With moderated subscription the manager must approve all requests to be subscribed";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Board)g).getModeratedsubscription_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setModeratedsubscription_unsafe((Boolean)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Board)g).getModeratedsubscription();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setModeratedsubscription((Boolean)raw);
            }
        };
        this.defineColumn((Column)this.col_moderatedsubscription);
        this.col_openposting = new Column<Boolean>((Table)this, "openposting", (SQLPoemType)new BooleanPoemType(false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Board)g).getOpenposting();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Board)g).setOpenposting((Boolean)cooked);
            }

            public Field<Boolean> asField(Persistent g) {
                return ((Board)g).getOpenpostingField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public String defaultDisplayName() {
                return "Open Posting";
            }

            public int defaultDisplayOrder() {
                return 8;
            }

            public String defaultDescription() {
                return "With open posting anyone with a user account can post a message to this list. Otherwise, only members can post";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Board)g).getOpenposting_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setOpenposting_unsafe((Boolean)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Board)g).getOpenposting();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setOpenposting((Boolean)raw);
            }
        };
        this.defineColumn((Column)this.col_openposting);
        this.col_moderatedposting = new Column<Boolean>((Table)this, "moderatedposting", (SQLPoemType)new BooleanPoemType(false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Board)g).getModeratedposting();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Board)g).setModeratedposting((Boolean)cooked);
            }

            public Field<Boolean> asField(Persistent g) {
                return ((Board)g).getModeratedpostingField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public String defaultDisplayName() {
                return "Moderated Posting";
            }

            public int defaultDisplayOrder() {
                return 9;
            }

            public String defaultDescription() {
                return "With moderated posting all messages must be approved by a manager";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Board)g).getModeratedposting_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setModeratedposting_unsafe((Boolean)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Board)g).getModeratedposting();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setModeratedposting((Boolean)raw);
            }
        };
        this.defineColumn((Column)this.col_moderatedposting);
        this.col_openmessageviewing = new Column<Boolean>((Table)this, "openmessageviewing", (SQLPoemType)new BooleanPoemType(false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Board)g).getOpenmessageviewing();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Board)g).setOpenmessageviewing((Boolean)cooked);
            }

            public Field<Boolean> asField(Persistent g) {
                return ((Board)g).getOpenmessageviewingField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public String defaultDisplayName() {
                return "Open Message Viewing";
            }

            public int defaultDisplayOrder() {
                return 10;
            }

            public String defaultDescription() {
                return "With open message viewing anyone can view messages in a board. Otherwise, only members can see messages";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Board)g).getOpenmessageviewing_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setOpenmessageviewing_unsafe((Boolean)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Board)g).getOpenmessageviewing();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setOpenmessageviewing((Boolean)raw);
            }
        };
        this.defineColumn((Column)this.col_openmessageviewing);
        this.col_openmemberlist = new Column<Boolean>((Table)this, "openmemberlist", (SQLPoemType)new BooleanPoemType(false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Board)g).getOpenmemberlist();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Board)g).setOpenmemberlist((Boolean)cooked);
            }

            public Field<Boolean> asField(Persistent g) {
                return ((Board)g).getOpenmemberlistField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public String defaultDisplayName() {
                return "Open Member List";
            }

            public int defaultDisplayOrder() {
                return 11;
            }

            public String defaultDescription() {
                return "With open member list anyone can see the members of the list. Otherwise, only members can see who else is subscribed";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Board)g).getOpenmemberlist_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setOpenmemberlist_unsafe((Boolean)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Board)g).getOpenmemberlist();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setOpenmemberlist((Boolean)raw);
            }
        };
        this.defineColumn((Column)this.col_openmemberlist);
        this.col_attachmentsallowed = new Column<Boolean>((Table)this, "attachmentsallowed", (SQLPoemType)new BooleanPoemType(false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Board)g).getAttachmentsallowed();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Board)g).setAttachmentsallowed((Boolean)cooked);
            }

            public Field<Boolean> asField(Persistent g) {
                return ((Board)g).getAttachmentsallowedField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public String defaultDisplayName() {
                return "Attachments Allowed";
            }

            public int defaultDisplayOrder() {
                return 12;
            }

            public String defaultDescription() {
                return "Can attachments be sent with messages. If not, attachments are ignored";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Board)g).getAttachmentsallowed_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setAttachmentsallowed_unsafe((Boolean)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Board)g).getAttachmentsallowed();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setAttachmentsallowed((Boolean)raw);
            }
        };
        this.defineColumn((Column)this.col_attachmentsallowed);
        this.col_anonymousposting = new Column<Boolean>((Table)this, "anonymousposting", (SQLPoemType)new BooleanPoemType(false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Board)g).getAnonymousposting();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Board)g).setAnonymousposting((Boolean)cooked);
            }

            public Field<Boolean> asField(Persistent g) {
                return ((Board)g).getAnonymouspostingField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public String defaultDisplayName() {
                return "Anonymous Posting Allowed";
            }

            public int defaultDisplayOrder() {
                return 13;
            }

            public String defaultDescription() {
                return "Can people without user accounts post to this messageboard. If so, a user account is created for them when they post.";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Board)g).getAnonymousposting_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setAnonymousposting_unsafe((Boolean)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Board)g).getAnonymousposting();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setAnonymousposting((Boolean)raw);
            }
        };
        this.defineColumn((Column)this.col_anonymousposting);
        this.col_attachmentspath = new Column<String>((Table)this, "attachmentspath", (SQLPoemType)new StringPoemType(false, -1), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Board)g).getAttachmentspath();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Board)g).setAttachmentspath((String)cooked);
            }

            public Field<String> asField(Persistent g) {
                return ((Board)g).getAttachmentspathField();
            }

            public boolean defaultUserCreateable() {
                return false;
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public String defaultDisplayName() {
                return "Attachments Path";
            }

            public int defaultDisplayOrder() {
                return 14;
            }

            public String defaultDescription() {
                return "A path to the directory containing attachments for this board";
            }

            public int defaultWidth() {
                return 70;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Board)g).getAttachmentspath_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setAttachmentspath_unsafe((String)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Board)g).getAttachmentspath();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setAttachmentspath((String)raw);
            }
        };
        this.defineColumn((Column)this.col_attachmentspath);
        this.col_attachmentsurl = new Column<String>((Table)this, "attachmentsurl", (SQLPoemType)new StringPoemType(false, -1), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Board)g).getAttachmentsurl();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Board)g).setAttachmentsurl((String)cooked);
            }

            public Field<String> asField(Persistent g) {
                return ((Board)g).getAttachmentsurlField();
            }

            public boolean defaultUserCreateable() {
                return false;
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public String defaultDisplayName() {
                return "Attachments URL";
            }

            public int defaultDisplayOrder() {
                return 15;
            }

            public String defaultDescription() {
                return "A URL to the directory containing attachments for this board";
            }

            public int defaultWidth() {
                return 70;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Board)g).getAttachmentsurl_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setAttachmentsurl_unsafe((String)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Board)g).getAttachmentsurl();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Board)g).setAttachmentsurl((String)raw);
            }
        };
        this.defineColumn((Column)this.col_attachmentsurl);
    }

    public final Column<Integer> getIdColumn() {
        return this.col_id;
    }

    public final Column<Integer> getTypeColumn() {
        return this.col_type;
    }

    public final Column<String> getNameColumn() {
        return this.col_name;
    }

    public final Column<String> getDisplaynameColumn() {
        return this.col_displayname;
    }

    public final Column<String> getPurposeColumn() {
        return this.col_purpose;
    }

    public final Column<Boolean> getArchivedColumn() {
        return this.col_archived;
    }

    public final Column<Boolean> getOpensubscriptionColumn() {
        return this.col_opensubscription;
    }

    public final Column<Boolean> getModeratedsubscriptionColumn() {
        return this.col_moderatedsubscription;
    }

    public final Column<Boolean> getOpenpostingColumn() {
        return this.col_openposting;
    }

    public final Column<Boolean> getModeratedpostingColumn() {
        return this.col_moderatedposting;
    }

    public final Column<Boolean> getOpenmessageviewingColumn() {
        return this.col_openmessageviewing;
    }

    public final Column<Boolean> getOpenmemberlistColumn() {
        return this.col_openmemberlist;
    }

    public final Column<Boolean> getAttachmentsallowedColumn() {
        return this.col_attachmentsallowed;
    }

    public final Column<Boolean> getAnonymouspostingColumn() {
        return this.col_anonymousposting;
    }

    public final Column<String> getAttachmentspathColumn() {
        return this.col_attachmentspath;
    }

    public final Column<String> getAttachmentsurlColumn() {
        return this.col_attachmentsurl;
    }

    public Board getBoardObject(Integer troid) {
        return (Board)this.getObject(troid);
    }

    public Board getBoardObject(int troid) {
        return (Board)this.getObject(troid);
    }

    protected JdbcPersistent _newPersistent() {
        return new Board();
    }

    public String defaultDisplayName() {
        return "Board";
    }

    public String defaultDescription() {
        return "A board for messages";
    }

    public boolean defaultRememberAllTroids() {
        return true;
    }

    public Integer defaultCacheLimit() {
        return new Integer(2000);
    }

    public String defaultCategory() {
        return "Boards";
    }

    public int defaultDisplayOrder() {
        return 1020;
    }

    public Board ensure(BoardType type, String name, String displayname, Boolean archived, Boolean opensubscription, Boolean moderatedsubscription, Boolean openposting, Boolean moderatedposting, Boolean openmessageviewing, Boolean openmemberlist, Boolean attachmentsallowed, Boolean anonymousposting, String attachmentspath, String attachmentsurl) {
        Board p = (Board)this.getNameColumn().firstWhereEq((Object)name);
        if (p == null) {
            p = (Board)this.newPersistent();
            p.setType(type);
            p.setName(name);
            p.setDisplayname(displayname);
            p.setArchived(archived);
            p.setOpensubscription(opensubscription);
            p.setModeratedsubscription(moderatedsubscription);
            p.setOpenposting(openposting);
            p.setModeratedposting(moderatedposting);
            p.setOpenmessageviewing(openmessageviewing);
            p.setOpenmemberlist(openmemberlist);
            p.setAttachmentsallowed(attachmentsallowed);
            p.setAnonymousposting(anonymousposting);
            p.setAttachmentspath(attachmentspath);
            p.setAttachmentsurl(attachmentsurl);
        }
        return (Board)this.getNameColumn().ensure((Persistent)p);
    }
}

