/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.model.generated;

import org.melati.poem.AccessPoemException;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.Column;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.DisplayLevel;
import org.melati.poem.Field;
import org.melati.poem.JdbcPersistent;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.ReferencePoemType;
import org.melati.poem.SQLPoemType;
import org.melati.poem.Searchability;
import org.melati.poem.StandardIntegrityFix;
import org.melati.poem.Table;
import org.melati.poem.TroidPoemType;
import org.melati.poem.ValidationPoemException;
import org.paneris.melati.boards.model.Board;
import org.paneris.melati.boards.model.BoardsDatabaseTables;
import org.paneris.melati.boards.model.BoardsTable;
import org.paneris.melati.boards.model.MembershipStatus;
import org.paneris.melati.boards.model.Subscription;
import org.paneris.melati.boards.model.User;

public class SubscriptionTableBase<T extends Subscription>
extends BoardsTable<T> {
    private Column<Integer> col_id = null;
    private Column<Integer> col_user = null;
    private Column<Integer> col_board = null;
    private Column<Integer> col_status = null;
    private Column<Boolean> col_ismanager = null;
    private Column<Boolean> col_approved = null;

    public SubscriptionTableBase(Database database, String name, DefinitionSource definitionSource) throws PoemException {
        super(database, name, definitionSource);
    }

    public BoardsDatabaseTables getBoardsDatabaseTables() {
        return (BoardsDatabaseTables)this.getDatabase();
    }

    public void init() throws PoemException {
        super.init();
        this.col_id = new Column<Integer>((Table)this, "id", (SQLPoemType)new TroidPoemType(), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Subscription)g).getId();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Subscription)g).setId((Integer)cooked);
            }

            public Field<Integer> asField(Persistent g) {
                return ((Subscription)g).getIdField();
            }

            public boolean defaultUserEditable() {
                return false;
            }

            public boolean defaultUserCreateable() {
                return false;
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.primary;
            }

            public int defaultDisplayOrder() {
                return 0;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Subscription)g).getId_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Subscription)g).setId_unsafe((Integer)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Subscription)g).getId();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Subscription)g).setId((Integer)raw);
            }
        };
        this.defineColumn((Column)this.col_id);
        this.col_user = new Column<Integer>((Table)this, "user", (SQLPoemType)new ReferencePoemType(this.getBoardsDatabaseTables().getUserTable(), false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Subscription)g).getUser();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Subscription)g).setUser((User)((Object)cooked));
            }

            public Field<Integer> asField(Persistent g) {
                return ((Subscription)g).getUserField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.summary;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public int defaultDisplayOrder() {
                return 1;
            }

            public String defaultDescription() {
                return "The user";
            }

            public boolean defaultIndexed() {
                return true;
            }

            public String defaultRenderinfo() {
                return "SelectionWindow";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Subscription)g).getUser_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Subscription)g).setUser_unsafe((Integer)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Subscription)g).getUserTroid();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Subscription)g).setUserTroid((Integer)raw);
            }

            public StandardIntegrityFix defaultIntegrityFix() {
                return StandardIntegrityFix.delete;
            }
        };
        this.defineColumn((Column)this.col_user);
        this.col_board = new Column<Integer>((Table)this, "board", (SQLPoemType)new ReferencePoemType(this.getBoardsDatabaseTables().getBoardTable(), false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Subscription)g).getBoard();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Subscription)g).setBoard((Board)((Object)cooked));
            }

            public Field<Integer> asField(Persistent g) {
                return ((Subscription)g).getBoardField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.summary;
            }

            public Searchability defaultSearchability() {
                return Searchability.primary;
            }

            public int defaultDisplayOrder() {
                return 2;
            }

            public String defaultDescription() {
                return "The board to which this user belongs";
            }

            public boolean defaultIndexed() {
                return true;
            }

            public String defaultRenderinfo() {
                return "SelectionWindow";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Subscription)g).getBoard_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Subscription)g).setBoard_unsafe((Integer)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Subscription)g).getBoardTroid();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Subscription)g).setBoardTroid((Integer)raw);
            }

            public StandardIntegrityFix defaultIntegrityFix() {
                return StandardIntegrityFix.delete;
            }
        };
        this.defineColumn((Column)this.col_board);
        this.col_status = new Column<Integer>((Table)this, "status", (SQLPoemType)new ReferencePoemType(this.getBoardsDatabaseTables().getMembershipStatusTable(), false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Subscription)g).getStatus();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Subscription)g).setStatus((MembershipStatus)((Object)cooked));
            }

            public Field<Integer> asField(Persistent g) {
                return ((Subscription)g).getStatusField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.summary;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public int defaultDisplayOrder() {
                return 3;
            }

            public String defaultDescription() {
                return "How users would like to receive emails from this board";
            }

            public boolean defaultIndexed() {
                return true;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Subscription)g).getStatus_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Subscription)g).setStatus_unsafe((Integer)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Subscription)g).getStatusTroid();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Subscription)g).setStatusTroid((Integer)raw);
            }
        };
        this.defineColumn((Column)this.col_status);
        this.col_ismanager = new Column<Boolean>((Table)this, "ismanager", (SQLPoemType)new BooleanPoemType(false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Subscription)g).getIsmanager();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Subscription)g).setIsmanager((Boolean)cooked);
            }

            public Field<Boolean> asField(Persistent g) {
                return ((Subscription)g).getIsmanagerField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.summary;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public String defaultDisplayName() {
                return "Is A Manager";
            }

            public int defaultDisplayOrder() {
                return 4;
            }

            public String defaultDescription() {
                return "Can the user administrator the board with manager priviledges?";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Subscription)g).getIsmanager_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Subscription)g).setIsmanager_unsafe((Boolean)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Subscription)g).getIsmanager();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Subscription)g).setIsmanager((Boolean)raw);
            }
        };
        this.defineColumn((Column)this.col_ismanager);
        this.col_approved = new Column<Boolean>((Table)this, "approved", (SQLPoemType)new BooleanPoemType(false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Subscription)g).getApproved();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Subscription)g).setApproved((Boolean)cooked);
            }

            public Field<Boolean> asField(Persistent g) {
                return ((Subscription)g).getApprovedField();
            }

            public boolean defaultUserCreateable() {
                return false;
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.summary;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public String defaultDisplayName() {
                return "Approved";
            }

            public int defaultDisplayOrder() {
                return 5;
            }

            public String defaultDescription() {
                return "Has this user's subscription to this board been approved by a manager (if the board has moderated subscription)";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Subscription)g).getApproved_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Subscription)g).setApproved_unsafe((Boolean)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Subscription)g).getApproved();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Subscription)g).setApproved((Boolean)raw);
            }
        };
        this.defineColumn((Column)this.col_approved);
    }

    public final Column<Integer> getIdColumn() {
        return this.col_id;
    }

    public final Column<Integer> getUserColumn() {
        return this.col_user;
    }

    public final Column<Integer> getBoardColumn() {
        return this.col_board;
    }

    public final Column<Integer> getStatusColumn() {
        return this.col_status;
    }

    public final Column<Boolean> getIsmanagerColumn() {
        return this.col_ismanager;
    }

    public final Column<Boolean> getApprovedColumn() {
        return this.col_approved;
    }

    public Subscription getSubscriptionObject(Integer troid) {
        return (Subscription)this.getObject(troid);
    }

    public Subscription getSubscriptionObject(int troid) {
        return (Subscription)this.getObject(troid);
    }

    protected JdbcPersistent _newPersistent() {
        return new Subscription();
    }

    public String defaultDisplayName() {
        return "Subscription";
    }

    public String defaultDescription() {
        return "Which users are members of which boards with what settings";
    }

    public String defaultCategory() {
        return "Boards";
    }

    public int defaultDisplayOrder() {
        return 1040;
    }
}

