/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.receivemail;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

public class Log {
    private static PrintWriter target = new PrintWriter(System.err);
    private static DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
    private String module = null;

    public Log(String module) {
        this.module = module;
    }

    public void setTarget(PrintWriter target) {
        Log.target = target;
        target.println("*** BEGIN: " + dateFormat.format(new Date()) + " : " + this.module + " ***");
    }

    public void setTarget(String path) {
        PrintWriter out;
        try {
            out = new PrintWriter(new FileWriter(path, true));
        }
        catch (Exception e) {
            out = new PrintWriter(System.err);
        }
        this.setTarget(out);
        out.flush();
    }

    public void write(String message) {
        try {
            target.println(dateFormat.format(new Date()) + "\t" + this.module + "\t" + message);
            target.flush();
        }
        catch (Exception e) {
            System.err.println("** COULD NOT WRITE LOG! SWITCHING TO STDERR **");
            System.err.println(dateFormat.format(new Date()) + "\t" + message);
            System.err.flush();
            this.setTarget(new PrintWriter(System.err));
        }
    }

    public void exception(Exception e) {
        this.write("EXCEPTION:");
        e.printStackTrace(target);
        target.flush();
    }

    public void debug(String s) {
        this.write("DEBUG: " + s);
    }

    public void error(String s) {
        this.write("ERROR: " + s);
    }

    public void warning(String s) {
        this.write("WARNING: " + s);
    }
}

