/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.receivemail;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.melati.util.PropertiesUtils;
import org.paneris.melati.boards.receivemail.Log;
import org.paneris.melati.boards.receivemail.SMTPServer;

public class SMTPServerServlet
implements Servlet {
    private ServletConfig config;
    Thread smtpserverThread = null;
    private static final int portDefault = 1615;
    private static final String propertiesNameDefault = "smtpServer.properties";
    private static final String logPathDefault = "/var/log/messageboard-receivemail.log";

    public void init(ServletConfig configP) throws ServletException {
        String logP;
        this.config = configP;
        Log log = new Log("ReceiveMail");
        int port = 1615;
        String propertiesName = propertiesNameDefault;
        String logPath = null;
        String pt = this.config.getInitParameter("port");
        port = new Integer(pt);
        String props = this.config.getInitParameter("properties");
        if (props != null && !props.equals("")) {
            propertiesName = props;
        }
        if ((logP = this.config.getInitParameter("log")) != null && !logP.equals("")) {
            logPath = logP;
            log.setTarget(logPath);
        }
        try {
            if (logPath == null) {
                log.setTarget(logPathDefault);
            }
            Properties databaseNameOfDomain = PropertiesUtils.fromResource(new SMTPServerServlet().getClass(), (String)propertiesName);
            if (this.smtpserverThread == null) {
                this.smtpserverThread = new Thread((Runnable)new SMTPServer(this, "messageboards." + InetAddress.getLocalHost().getHostName(), port, databaseNameOfDomain, 65536, log), "board smtpserver");
                this.smtpserverThread.start();
                log.debug("Started SMTP server servlet");
            }
        }
        catch (Exception e) {
            log.exception(e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void destroy() {
        this.smtpserverThread = null;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "A servlet to launch an SMTP server which receives emails for the boards system.";
    }

    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        PrintWriter out = resp.getWriter();
        out.println("The SMTP server is " + (this.smtpserverThread != null ? "running" : "not running"));
        out.close();
    }
}

