/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.receivemail.nntp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Properties;
import org.paneris.melati.boards.receivemail.Log;
import org.paneris.melati.boards.receivemail.nntp.NNTPSession;

public class NNTPServer
implements Runnable {
    private String identifier = null;
    private int port = 119;
    private Properties config = null;
    private int buffSize = 65536;
    private Log log = null;
    private Thread myThread = Thread.currentThread();
    private ServerSocket serverSocket = null;

    public NNTPServer(String identifier, int port, Properties config, int bufSize, Log log) {
        int shutUp;
        this.identifier = identifier;
        this.port = port;
        this.config = config;
        this.buffSize = bufSize;
        this.log = log;
        this.buffSize = shutUp = this.buffSize;
    }

    @Override
    public void run() {
        try {
            this.serverSocket = new ServerSocket(this.port);
            while (!this.myThread.isInterrupted()) {
                new NNTPSession(this.identifier, this.serverSocket.accept(), this.config, this.log).start();
            }
        }
        catch (SocketException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!this.serverSocket.isClosed()) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.myThread = null;
        }
    }

    public synchronized void stop() throws IllegalStateException {
        if (this.myThread == null) {
            throw new IllegalStateException("Server is not running");
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.myThread.interrupt();
    }
}

