/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.receivemail.nntp;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.paneris.melati.boards.receivemail.Log;
import org.paneris.melati.boards.receivemail.nntp.NNTPServer;

public class NNTPServerServlet
implements Servlet {
    private ServletConfig config = null;
    static Thread nntpServerThread = null;
    private static final String logPathDefault = "/var/log/messageboard-nntp.log";
    private static int port = 119;
    Log log = new Log("nntp");
    String identifier = null;
    Properties props = null;
    private static int buffSize = 65536;
    private static NNTPServer server;
    private String databaseName = null;
    private String prefix = null;
    private String logPath = null;

    public void init(ServletConfig configP) throws ServletException {
        this.config = configP;
        this.logPath = this.config.getInitParameter("log");
        if (this.logPath == null) {
            this.logPath = logPathDefault;
        }
        this.log.setTarget(this.logPath);
        this.databaseName = this.config.getInitParameter("database");
        this.prefix = this.config.getInitParameter("prefix");
        String portS = this.config.getInitParameter("port");
        if (portS != null) {
            port = Integer.parseInt(portS);
        }
        this.identifier = this.config.getInitParameter("identifier");
        String buffSizeS = this.config.getInitParameter("buffSize");
        if (buffSizeS != null) {
            buffSize = Integer.parseInt(buffSizeS);
        }
        try {
            if (this.identifier == null) {
                this.identifier = "messageboards." + InetAddress.getLocalHost().getHostName();
            }
            this.props = new Properties();
            this.props.setProperty("database", this.databaseName);
            this.props.setProperty("prefix", this.prefix);
            server = new NNTPServer(this.identifier, port, this.props, buffSize, this.log);
            if (nntpServerThread == null) {
                nntpServerThread = new Thread((Runnable)server, "boards nntpserver");
                nntpServerThread.start();
                this.log.debug("Started NNTP server servlet");
            }
        }
        catch (Exception e) {
            this.log.exception(e);
        }
    }

    public void destroy() {
        try {
            if (nntpServerThread != null) {
                server.stop();
            }
        }
        catch (Exception e) {
            this.log.exception(e);
        }
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "NNTP Server launcher for Melati boards system";
    }

    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        PrintWriter out = resp.getWriter();
        out.println("<html>\n<head>\n<title>");
        out.println("NNTP Server Status");
        out.println("</title>\n</head>");
        out.println("<body>");
        out.println("<h1>NNTP Server Status</h1>");
        out.println("<table border='1'>");
        out.println("<tr>");
        out.println("<th>Setting</th>");
        out.println("<th>Value</th>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>logPath</td>");
        out.println("<td>" + this.logPath + "</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>port</td>");
        out.println("<td>" + port + "</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>identifier</td>");
        out.println("<td>" + this.identifier + "</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>prefix</td>");
        out.println("<td>" + this.prefix + "</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>buffSize</td>");
        out.println("<td>" + buffSize + "</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>databaseName</td>");
        out.println("<td>" + this.databaseName + "</td>");
        out.println("</tr>");
        out.println("</table>");
        String cmd = req.getParameter("cmd");
        if ("start".equalsIgnoreCase(cmd)) {
            this.log.debug("Starting server");
            if (nntpServerThread == null) {
                nntpServerThread = new Thread((Runnable)server, "boards nntpserver");
                nntpServerThread.start();
                this.log.debug("Started NNTP server servlet");
            } else {
                out.println("<p>It aint null</p>");
            }
        } else if ("stop".equalsIgnoreCase(cmd)) {
            System.err.println("Stopping server");
            try {
                server.stop();
                nntpServerThread = null;
            }
            catch (Exception e) {
                this.log.exception(e);
            }
        }
        out.println("The NNTP server is " + (nntpServerThread != null ? "running [<a href='?cmd=stop'>stop</a>]" : "not running [<a href='?cmd=start'>start</a>]"));
        out.println("</body>\n</html>");
        out.flush();
        out.close();
    }
}

