/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.receivemail.nntp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.melati.poem.AccessPoemException;
import org.melati.poem.AccessToken;
import org.melati.poem.PoemDatabase;
import org.melati.poem.PoemTask;
import org.paneris.melati.boards.model.Attachment;
import org.paneris.melati.boards.model.Board;
import org.paneris.melati.boards.model.Message;
import org.paneris.melati.boards.model.User;
import org.paneris.melati.boards.receivemail.DotTerminatedInputStream;
import org.paneris.melati.boards.receivemail.Log;
import org.paneris.melati.boards.receivemail.nntp.NNTPMessage;
import org.paneris.melati.boards.receivemail.nntp.NNTPStore;
import org.paneris.melati.boards.receivemail.nntp.UnknownNewsGroupException;

public class NNTPSession
extends Thread {
    public static final SimpleDateFormat nntpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    public static final DateFormat longRFC977DateFormat = new SimpleDateFormat("yyyyMMdd HHmmss", Locale.ENGLISH);
    public static final DateFormat shortRFC977DateFormat = new SimpleDateFormat("yyMMdd HHmmss", Locale.ENGLISH);
    private String nntpIdentifier;
    private Socket socket;
    private BufferedReader reader;
    private Properties config;
    private PrintWriter writer;
    private Log log = null;
    private String prefix;
    private NNTPStore store = null;
    private String selectedGroup = null;
    private AuthInfo authInfo = null;

    NNTPSession(String nntpIdentifier, Socket socket, Properties configP, Log log) throws IOException {
        this.nntpIdentifier = nntpIdentifier;
        this.socket = socket;
        this.config = configP;
        this.log = log;
        this.prefix = this.config.getProperty("prefix");
        try {
            this.store = new NNTPStore(this.config.getProperty("database"), this.prefix, nntpIdentifier);
            this.authInfo = new AuthInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream())){

            @Override
            public String readLine() throws IOException {
                String s = super.readLine();
                if (s.trim().length() == 0) {
                    System.err.println("C: [empty line]");
                }
                System.err.println("C: " + s);
                return s;
            }
        };
        this.writer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream())){

            @Override
            public void println() {
                this.print("\r\n");
                this.flush();
            }

            @Override
            public void println(String s) {
                super.println(s);
                System.err.println("S: " + s);
            }
        };
    }

    private void reset() {
        this.store = null;
    }

    @Override
    public void run() {
        try {
            System.err.println("Connection from " + this.socket.getInetAddress());
            this.writer.println("200 " + this.nntpIdentifier + " server ready - posting allowed");
            while (this.socket != null && !this.socket.isClosed()) {
                String command = this.reader.readLine();
                if (this.handleCommand(command)) continue;
                break;
            }
        }
        catch (Exception e) {
            this.writer.println("503 program fault - command not performed: " + e.toString());
            e.printStackTrace();
        }
        finally {
            try {
                if (this.socket != null && !this.socket.isClosed()) {
                    this.quit();
                }
                this.writer.close();
                this.reader.close();
            }
            catch (Exception e) {
                this.log.exception(e);
            }
        }
    }

    private boolean handleCommand(final String rawCommand) {
        BoardPoemTask task = new BoardPoemTask(){

            @Override
            public boolean execute() {
                if (rawCommand == null) {
                    return false;
                }
                StringTokenizer tokens = new StringTokenizer(rawCommand);
                if (!tokens.hasMoreTokens()) {
                    return true;
                }
                String command = tokens.nextToken();
                if (command.equalsIgnoreCase("QUIT")) {
                    NNTPSession.this.quit();
                } else if (command.equalsIgnoreCase("HELP")) {
                    NNTPSession.this.help();
                } else if (command.equalsIgnoreCase("MODE") && tokens.hasMoreTokens() && tokens.nextToken().equalsIgnoreCase("READER")) {
                    NNTPSession.this.modereader();
                } else if (command.equalsIgnoreCase("LIST")) {
                    NNTPSession.this.list(tokens);
                } else if (command.equalsIgnoreCase("NEWGROUPS")) {
                    NNTPSession.this.newgroups(tokens);
                } else if (command.equalsIgnoreCase("GROUP")) {
                    NNTPSession.this.group(tokens.hasMoreTokens() ? tokens.nextToken() : null);
                } else if (command.equalsIgnoreCase("XOVER")) {
                    NNTPSession.this.xover(tokens.hasMoreTokens() ? tokens.nextToken() : null);
                } else if (command.equalsIgnoreCase("ARTICLE")) {
                    NNTPSession.this.article(tokens.hasMoreTokens() ? tokens.nextToken() : null);
                } else if (command.equalsIgnoreCase("POST")) {
                    NNTPSession.this.post();
                } else if (command.equalsIgnoreCase("XPAT")) {
                    NNTPSession.this.xpat(tokens);
                } else if (command.equalsIgnoreCase("AUTHINFO")) {
                    NNTPSession.this.authinfo(tokens);
                }
                return true;
            }
        };
        PoemDatabase db = (PoemDatabase)this.store.getDb();
        if (db == null) {
            throw new RuntimeException("DB not initialised");
        }
        db.inSession((AccessToken)this.authInfo.getUser(), (PoemTask)task);
        return task.result;
    }

    private void quit() {
        this.writer.println("205 closing connection");
        try {
            this.socket.close();
            this.socket = null;
        }
        catch (Exception e) {
            this.log.exception(e);
        }
        this.reset();
    }

    private void authinfo(StringTokenizer tokens) {
        String command = tokens.nextToken();
        if (command.equalsIgnoreCase("USER")) {
            this.authInfo.login = tokens.nextToken();
            this.writer.println("381 More authentication information required");
        } else if (command.equalsIgnoreCase("PASS")) {
            this.authInfo.password = tokens.nextToken();
            this.store.establishUser(this.authInfo);
            if (this.authInfo.user != null) {
                this.writer.println("281 Authentication accepted");
            } else {
                this.writer.println("482 Authentication rejected");
            }
        } else {
            throw new RuntimeException("Unexpected command:" + command);
        }
    }

    private void post() {
        if (this.authInfo != null) {
            this.writer.println("340 send article to be posted. End with <CR-LF>.<CR-LF>");
            try {
                MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties(), null), (InputStream)new DotTerminatedInputStream(new PushbackInputStream(this.socket.getInputStream())));
                this.store.postMessage(message, this.authInfo.user);
                this.writer.println("240 article received ok");
            }
            catch (AccessPoemException e) {
                e.printStackTrace();
                this.writer.println("440 posting not allowed");
            }
            catch (Exception e) {
                this.writer.println("241 posting failed");
                this.log.exception(e);
            }
        } else {
            this.writer.println("440 posting not allowed");
        }
    }

    private void modereader() {
        this.writer.println("200 Posting Permitted");
    }

    private void help() {
        this.writer.println("100 Help text follows");
        this.writer.println(".");
    }

    private void xover(String range) {
        if (this.selectedGroup == null) {
            this.writer.println("412 No newsgroup selected");
            return;
        }
        try {
            Board brd = this.store.resolveTargetBoard(this.selectedGroup);
            Enumeration messages = this.store.getRange(range, brd);
            if (messages == null) {
                this.writer.println("420 No article(s) selected");
            } else {
                this.writer.println("224 Overview information follows");
                while (messages.hasMoreElements()) {
                    Message msg = (Message)((Object)messages.nextElement());
                    long byteCount = msg.getBody().length();
                    long lineCount = msg.getLines().length;
                    NNTPMessage nntpMsg = new NNTPMessage(msg);
                    int id = nntpMsg.getNntpIdInt();
                    String msgID = this.store.getArticleId(id);
                    String references = this.store.getReferences(msg);
                    String reply = id + "\t";
                    reply = reply + msg.getSubject() + "\t";
                    reply = reply + nntpMsg.getFrom() + "\t";
                    reply = reply + nntpDateFormat.format(msg.getDate()) + "\t";
                    reply = reply + msgID + "\t";
                    reply = reply + references + "\t";
                    reply = reply + (byteCount == -1L ? 300L : byteCount) + "\t";
                    reply = reply + lineCount + "";
                    this.writer.println(reply);
                }
                this.writer.println(".");
            }
        }
        catch (AccessPoemException e) {
            this.writer.println("502 No permission");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void article(String id) {
        if (id == null) {
            throw new RuntimeException("Article Id null");
        }
        int nntpMessageId = 0;
        try {
            nntpMessageId = Integer.decode(id);
        }
        catch (NumberFormatException e) {
            nntpMessageId = NNTPMessage.parseId(id);
        }
        try {
            NNTPMessage nntpMessage = this.store.getArticle(nntpMessageId);
            Message message = nntpMessage.getMessage();
            if (message != null) {
                int attachmentCount = message.getAttachmentCount();
                String boundary = "------------070200030503000409090500";
                this.writer.println("220 " + id + " " + this.store.getArticleId(nntpMessageId) + " article retrieved and follows");
                this.writer.flush();
                String references = this.store.getReferences(message);
                this.writer.println("From: " + nntpMessage.getFrom() + "\t");
                this.writer.println("Newsgroups: " + this.store.prefix + "." + message.getBoard().getName() + "\t");
                this.writer.println("Subject: " + message.getSubject());
                this.writer.println("Message-ID: " + this.store.getArticleId(nntpMessageId) + "\t");
                if (references.length() > 0) {
                    this.writer.println("References: " + references + "\t");
                }
                this.writer.println("Date: " + nntpDateFormat.format(message.getDate()) + "\t");
                if (attachmentCount > 0) {
                    this.writer.println("Content-Type: multipart/mixed; boundary=\"" + boundary + "\"\t");
                    this.writer.println();
                    this.writer.println("This is a multi-part message in MIME format.");
                    this.writer.println("--" + boundary);
                    this.writer.println("Content-Type: text/plain\t");
                    this.writer.println("Content-Transfer-Encoding: 8bit\t");
                }
                this.writer.println();
                this.writer.println(message.getBody());
                if (attachmentCount > 0) {
                    Enumeration attachments = message.getAttachments();
                    while (attachments.hasMoreElements()) {
                        int c;
                        Attachment element = (Attachment)((Object)attachments.nextElement());
                        File f = new File(element.getPath());
                        if (!f.exists()) continue;
                        String contentType = element.getType().getType();
                        String transferEncoding = "base64";
                        if (element.getType().getType().equalsIgnoreCase("truncation")) {
                            contentType = "text/plain";
                            transferEncoding = "8bit";
                        }
                        this.writer.println();
                        this.writer.println("--" + boundary);
                        this.writer.println("Content-Type: " + contentType + "; name=\"" + element.getFilename() + "\"\t");
                        this.writer.println("Content-Transfer-Encoding: " + transferEncoding + "\t");
                        this.writer.println("Content-Disposition: inline; filename=\"" + element.getFilename() + "\"\t");
                        this.writer.println();
                        this.writer.flush();
                        OutputStream out = MimeUtility.encode((OutputStream)this.socket.getOutputStream(), (String)transferEncoding);
                        FileInputStream in = new FileInputStream(element.getPath());
                        byte[] buffer = new byte[512];
                        while ((c = in.read(buffer)) != -1) {
                            out.write(buffer, 0, c);
                        }
                        out.flush();
                    }
                    this.writer.println("\r\n--" + boundary + "--");
                }
                this.writer.println(".");
                this.writer.flush();
            } else {
                this.writer.println("430 no such article found");
            }
        }
        catch (AccessPoemException e) {
            this.writer.println("502 no permission");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writer.println("503 program error function not performed");
        }
    }

    private void group(String name) {
        try {
            Board board = this.store.getBoard(name);
            if (board == null) {
                throw new UnknownNewsGroupException("Board " + name + "not found");
            }
            int count = board.getMessageCount();
            int first = board.getFirstMessageId() + 1;
            int last = board.getLastMessageId() + 1;
            if (count == 0) {
                first = 0;
                last = 0;
            }
            this.writer.println("211 " + count + " " + first + " " + last + " " + name + " group selected");
            this.selectedGroup = name;
        }
        catch (AccessPoemException e) {
            this.writer.println("411 no such newsgroup");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writer.println("503 program fault - command not performed: " + e.toString());
        }
    }

    private Date getDateFrom(StringTokenizer tok) {
        try {
            String dateStr = tok.nextToken() + " " + tok.nextToken();
            boolean utc = tok.hasMoreTokens();
            Date dt = null;
            dt = dateStr.indexOf(32) == 6 ? shortRFC977DateFormat.parse(dateStr) : longRFC977DateFormat.parse(dateStr);
            if (utc) {
                dt = new Date(dt.getTime() + (long)Calendar.getInstance().get(15));
            }
            return dt;
        }
        catch (ParseException pe) {
            return null;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private void newgroups(StringTokenizer tok) {
        this.writer.println("231 list of new newsgroups follows");
        Enumeration boards = this.store.getBoards(this.getDateFrom(tok), null);
        if (boards != null) {
            while (boards.hasMoreElements()) {
                Board board = (Board)((Object)boards.nextElement());
                this.writer.println(this.store.prefix + "." + board.getName() + " " + board.getPurpose());
            }
        }
        this.writer.println(".");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void list(StringTokenizer tok) {
        block9: {
            Enumeration boards;
            block10: {
                Enumeration boards2;
                block13: {
                    String param;
                    block12: {
                        String wildmat;
                        block11: {
                            String[] unsupported;
                            block8: {
                                block7: {
                                    wildmat = "*";
                                    if (!tok.hasMoreTokens()) break block7;
                                    param = tok.nextToken();
                                    unsupported = new String[]{"ACTIVE.TIMES", "DISTRIBUTIONS", "DISTRIB.PATS", "SUBSCRIPTIONS"};
                                    break block8;
                                }
                                this.writer.println("215 list of newsgroups follows");
                                boards = this.store.getBoards(null, null);
                                if (boards == null) break block9;
                                break block10;
                            }
                            for (int i = 0; i < unsupported.length; ++i) {
                                if (!unsupported[i].equalsIgnoreCase(param)) continue;
                                this.writer.println("501 command not supported");
                                return;
                            }
                            if (tok.hasMoreTokens()) {
                                wildmat = tok.nextToken();
                            }
                            if (!param.equalsIgnoreCase("NEWSGROUPS")) break block11;
                            this.writer.println("215 list of newsgroups follows");
                            Enumeration boards3 = this.store.getBoards(null, wildmat);
                            if (boards3 != null) {
                                while (boards3.hasMoreElements()) {
                                    Board board = (Board)((Object)boards3.nextElement());
                                    this.writer.println(this.store.prefix + "." + board.getName() + " " + board.getDisplayname() + " " + board.getPurpose());
                                }
                            }
                            break block9;
                        }
                        if (!param.equalsIgnoreCase("ACTIVE")) break block12;
                        this.writer.println("215 list of newsgroups follows");
                        boards2 = this.store.getBoards(null, wildmat);
                        if (boards2 == null) break block9;
                        break block13;
                    }
                    if (!param.equalsIgnoreCase("OVERVIEW.FMT")) {
                        this.writer.println("501 command not supported");
                        return;
                    }
                    this.writer.println("215 Order of fields in overview database");
                    this.writer.println("Subject:");
                    this.writer.println("From:");
                    this.writer.println("Date:");
                    this.writer.println("Message-ID:");
                    this.writer.println("References:");
                    this.writer.println("Bytes:");
                    this.writer.println("Lines:");
                    this.writer.println("Xref:full");
                    break block9;
                }
                while (boards2.hasMoreElements()) {
                    Board board = (Board)((Object)boards2.nextElement());
                    this.writer.println(this.store.prefix + "." + board.getName() + " " + (board.getModeratedposting() != false ? "n" : "y"));
                }
                break block9;
            }
            while (boards.hasMoreElements()) {
                Board board = (Board)((Object)boards.nextElement());
                this.writer.println(this.store.prefix + "." + board.getName() + " " + (board.getModeratedposting() != false ? "n" : "y"));
            }
        }
        this.writer.println(".");
    }

    private void xpat(StringTokenizer tok) {
        String header = "SUBJECT";
        header = tok.nextToken();
        String range = tok.nextToken();
        String wildmat = "";
        while (tok.hasMoreTokens()) {
            wildmat = wildmat + " " + tok.nextToken();
        }
        wildmat = wildmat.trim();
        this.store.xpat(header, range, wildmat, this.selectedGroup, this.writer);
    }

    static {
        nntpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    abstract class BoardPoemTask
    implements PoemTask {
        public boolean result = false;

        BoardPoemTask() {
        }

        public void run() {
            this.result = this.execute();
        }

        public abstract boolean execute();
    }

    public class AuthInfo {
        private String login = null;
        private String password = null;
        private User user = null;

        public AuthInfo() {
            this.user = (User)NNTPSession.this.store.getDb().getUserTable().guestUser();
        }

        public String getLogin() {
            return this.login;
        }

        public String getPassword() {
            return this.password;
        }

        public User getUser() {
            return this.user;
        }

        public void setUser(User user) {
            this.user = user;
        }
    }
}

