/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.model;

import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.TableInfo;
import org.paneris.melati.boards.model.MembershipStatus;
import org.paneris.melati.boards.model.generated.MembershipStatusTableBase;

public class MembershipStatusTable<T extends MembershipStatus>
extends MembershipStatusTableBase<MembershipStatus> {
    private MembershipStatus normal;
    private MembershipStatus digest;
    private MembershipStatus suspended;
    private MembershipStatus banned;

    public MembershipStatusTable(Database database, String name, DefinitionSource definitionSource) throws PoemException {
        super(database, name, definitionSource);
    }

    public void postInitialise() {
        super.postInitialise();
        this.normal = this.ensure("normal");
        this.digest = this.ensure("digest");
        this.suspended = this.ensure("suspended");
        this.banned = this.ensure("banned");
        TableInfo info = this.getInfo();
        if (info.getDefaultcanwrite() == null) {
            info.setDefaultcanwrite(this.getDatabase().administerCapability());
        }
        if (info.getCancreate() == null) {
            info.setCancreate(this.getDatabase().administerCapability());
        }
    }

    public MembershipStatus getNormal() {
        return this.normal;
    }

    public MembershipStatus getDigest() {
        return this.digest;
    }

    public MembershipStatus getSuspended() {
        return this.suspended;
    }

    public MembershipStatus getBanned() {
        return this.banned;
    }

    @Override
    public MembershipStatus ensure(String name) {
        MembershipStatus status = (MembershipStatus)this.getStatusColumn().firstWhereEq((Object)name);
        if (status != null) {
            return status;
        }
        status = (MembershipStatus)this.newPersistent();
        status.setStatus(name);
        return (MembershipStatus)this.getStatusColumn().ensure((Persistent)status);
    }
}

