/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.model;

import java.sql.Timestamp;
import java.util.Date;
import org.melati.poem.AccessPoemException;
import org.melati.poem.CachedCount;
import org.melati.poem.CachedSelection;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.InitialisationPoemException;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.ValidationPoemException;
import org.paneris.melati.boards.model.Board;
import org.paneris.melati.boards.model.Message;
import org.paneris.melati.boards.model.generated.MessageTableBase;

public class MessageTable<T extends Message>
extends MessageTableBase<Message> {
    public MessageTable(Database database, String name, DefinitionSource definitionSource) throws PoemException {
        super(database, name, definitionSource);
    }

    public void create(Persistent persistent) throws AccessPoemException, ValidationPoemException, InitialisationPoemException {
        Board b = this.getBoardsDatabaseTables().getBoardTable().getBoardObject(((Message)persistent).getBoard_unsafe());
        if ("".equals(((Message)persistent).getSubject_unsafe())) {
            persistent.setRaw("subject", (Object)"(no subject)");
        }
        Timestamp now = new Timestamp(new Date().getTime());
        persistent.setRaw("date", (Object)now);
        boolean approved = b.getModeratedposting_unsafe() == false || b.canManage(((Message)persistent).getAuthor());
        persistent.setRaw("approved", (Object)new Boolean(approved));
        super.create(persistent);
        if (approved) {
            Integer parent = ((Message)persistent).getParent_unsafe();
            if (parent == null) {
                b.addThread((Message)persistent, true);
            } else {
                b.addToParent((Message)persistent, this.getMessageObject(parent));
            }
        }
    }

    public String messageInBoardSQL(Board board, boolean approved) {
        return this.getBoardColumn().eqClause((Object)board.troid()) + " AND " + this.getApprovedColumn().eqClause((Object)new Boolean(approved)) + " AND " + this.getDeletedColumn().eqClause((Object)Boolean.FALSE);
    }

    public CachedSelection<?> cachedBoardRoots(Board board) {
        return this.cachedSelection(this.messageInBoardSQL(board, true) + " AND " + this.getParentColumn().eqClause(null), null);
    }

    public CachedCount cachedMessageCount(Board board) {
        return this.cachedCount(this.messageInBoardSQL(board, true));
    }

    public CachedSelection<?> cachedMessages(Board board) {
        return this.cachedSelection(this.messageInBoardSQL(board, false), null);
    }

    public CachedCount cachedPendingMessageCount(Board board) {
        return this.cachedCount(this.messageInBoardSQL(board, false));
    }

    public CachedSelection<?> cachedPendingMessages(Board board) {
        return this.cachedSelection(this.messageInBoardSQL(board, false), null);
    }
}

