/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.model;

import org.melati.poem.AccessPoemException;
import org.melati.poem.AccessToken;
import org.melati.poem.Capability;
import org.melati.poem.CreationAccessPoemException;
import org.melati.poem.PoemThread;
import org.paneris.melati.boards.model.Board;
import org.paneris.melati.boards.model.MembershipStatus;
import org.paneris.melati.boards.model.SubscribingGuestException;
import org.paneris.melati.boards.model.User;
import org.paneris.melati.boards.model.generated.SubscriptionBase;

public class Subscription
extends SubscriptionBase {
    public boolean isUsersDetails(User userP) {
        return this.getUser_unsafe().equals(userP.troid());
    }

    public void approve() {
        this.setApproved(Boolean.TRUE);
    }

    public void setUsersStatus(MembershipStatus status) {
        AccessToken token = PoemThread.accessToken();
        try {
            if (!this.isUsersDetails((User)token)) {
                throw new AccessPoemException(token, new Capability("Own Details"));
            }
            if (this.getStatus() == this.getBoardsDatabaseTables().getMembershipStatusTable().getBanned()) {
                throw new AccessPoemException(token, new Capability("Your are banned from this Board"));
            }
        }
        catch (ClassCastException e) {
            throw new AccessPoemException(token, new Capability("Own Details"));
        }
        this.setStatus_unsafe(status.troid());
    }

    public void assertCanRead(AccessToken token) throws AccessPoemException {
        if (token == AccessToken.root) {
            return;
        }
        try {
            Board b = this.getBoardsDatabaseTables().getBoardTable().getBoardObject(this.getBoard_unsafe());
            if (!this.isUsersDetails((User)token) && !b.canViewMembers((User)token)) {
                throw new AccessPoemException(token, new Capability("Member"));
            }
        }
        catch (ClassCastException e) {
            throw new AccessPoemException(token, new Capability("Member"));
        }
    }

    public void assertCanWrite(AccessToken token) throws AccessPoemException {
        this.assertCanRead(token);
    }

    public void assertCanCreate(AccessToken token) throws CreationAccessPoemException {
        if (token == AccessToken.root) {
            return;
        }
        try {
            Board b = this.getBoardsDatabaseTables().getBoardTable().getBoardObject(this.getBoard_unsafe());
            if (!b.canSubscribe((User)token)) {
                throw new CreationAccessPoemException(this.getTable(), token, new Capability("Manager"));
            }
        }
        catch (ClassCastException e) {
            throw new CreationAccessPoemException(this.getTable(), token, new Capability("Manager"));
        }
    }

    public void assertCanDelete(AccessToken token) throws AccessPoemException {
        if (token == AccessToken.root) {
            return;
        }
        try {
            Board b = this.getBoardsDatabaseTables().getBoardTable().getBoardObject(this.getBoard_unsafe());
            User u = (User)token;
            if (!b.canManage(u) && !this.isUsersDetails(u)) {
                throw new AccessPoemException(token, new Capability("Logged In or Manager"));
            }
            if (b.isBanned(u)) {
                throw new AccessPoemException(token, new Capability("Not Banned"));
            }
        }
        catch (ClassCastException e) {
            throw new AccessPoemException(token, new Capability("Logged In or Manager"));
        }
    }

    @Override
    public void setUser_unsafe(Integer cooked) {
        if (this.getDatabase().getUserTable().guestUser().troid() == cooked) {
            throw new SubscribingGuestException("You cannot subscribe the guest user to a board");
        }
        super.setUser_unsafe(cooked);
    }
}

