/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.model.generated;

import org.melati.poem.AccessPoemException;
import org.melati.poem.Column;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.DisplayLevel;
import org.melati.poem.Field;
import org.melati.poem.JdbcPersistent;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.SQLPoemType;
import org.melati.poem.Searchability;
import org.melati.poem.StringPoemType;
import org.melati.poem.Table;
import org.melati.poem.TroidPoemType;
import org.melati.poem.ValidationPoemException;
import org.paneris.melati.boards.model.BoardsDatabaseTables;
import org.paneris.melati.boards.model.BoardsTable;
import org.paneris.melati.boards.model.MembershipStatus;

public class MembershipStatusTableBase<T extends MembershipStatus>
extends BoardsTable<T> {
    private Column<Integer> col_id = null;
    private Column<String> col_status = null;

    public MembershipStatusTableBase(Database database, String name, DefinitionSource definitionSource) throws PoemException {
        super(database, name, definitionSource);
    }

    public BoardsDatabaseTables getBoardsDatabaseTables() {
        return (BoardsDatabaseTables)this.getDatabase();
    }

    public void init() throws PoemException {
        super.init();
        this.col_id = new Column<Integer>((Table)this, "id", (SQLPoemType)new TroidPoemType(), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((MembershipStatus)g).getId();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((MembershipStatus)g).setId((Integer)cooked);
            }

            public Field<Integer> asField(Persistent g) {
                return ((MembershipStatus)g).getIdField();
            }

            public boolean defaultUserEditable() {
                return false;
            }

            public boolean defaultUserCreateable() {
                return false;
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Integer defaultDisplayOrderPriority() {
                return new Integer(0);
            }

            public int defaultDisplayOrder() {
                return 0;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((MembershipStatus)g).getId_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((MembershipStatus)g).setId_unsafe((Integer)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((MembershipStatus)g).getId();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((MembershipStatus)g).setId((Integer)raw);
            }
        };
        this.defineColumn((Column)this.col_id);
        this.col_status = new Column<String>((Table)this, "status", (SQLPoemType)new StringPoemType(false, -1), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((MembershipStatus)g).getStatus();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((MembershipStatus)g).setStatus((String)cooked);
            }

            public Field<String> asField(Persistent g) {
                return ((MembershipStatus)g).getStatusField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.primary;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public int defaultDisplayOrder() {
                return 1;
            }

            public String defaultDescription() {
                return "The name of a status";
            }

            public boolean defaultUnique() {
                return true;
            }

            public int defaultWidth() {
                return 40;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((MembershipStatus)g).getStatus_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((MembershipStatus)g).setStatus_unsafe((String)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((MembershipStatus)g).getStatus();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((MembershipStatus)g).setStatus((String)raw);
            }
        };
        this.defineColumn((Column)this.col_status);
    }

    public final Column<Integer> getIdColumn() {
        return this.col_id;
    }

    public final Column<String> getStatusColumn() {
        return this.col_status;
    }

    public MembershipStatus getMembershipStatusObject(Integer troid) {
        return (MembershipStatus)this.getObject(troid);
    }

    public MembershipStatus getMembershipStatusObject(int troid) {
        return (MembershipStatus)this.getObject(troid);
    }

    protected JdbcPersistent _newPersistent() {
        return new MembershipStatus();
    }

    public String defaultDisplayName() {
        return "Membership Status";
    }

    public String defaultDescription() {
        return "The status of a user's subscription to a board";
    }

    public boolean defaultRememberAllTroids() {
        return true;
    }

    public Integer defaultCacheLimit() {
        return new Integer(999999999);
    }

    public String defaultCategory() {
        return "Boards";
    }

    public int defaultDisplayOrder() {
        return 1030;
    }

    public MembershipStatus ensure(String status) {
        MembershipStatus p = (MembershipStatus)this.getStatusColumn().firstWhereEq((Object)status);
        if (p == null) {
            p = (MembershipStatus)this.newPersistent();
            p.setStatus(status);
        }
        return (MembershipStatus)this.getStatusColumn().ensure((Persistent)p);
    }
}

