/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.model.generated;

import java.sql.Timestamp;
import org.melati.poem.AccessPoemException;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.Column;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.DisplayLevel;
import org.melati.poem.Field;
import org.melati.poem.JdbcPersistent;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.ReferencePoemType;
import org.melati.poem.SQLPoemType;
import org.melati.poem.Searchability;
import org.melati.poem.StandardIntegrityFix;
import org.melati.poem.StringPoemType;
import org.melati.poem.Table;
import org.melati.poem.TimestampPoemType;
import org.melati.poem.TroidPoemType;
import org.melati.poem.ValidationPoemException;
import org.paneris.melati.boards.model.Board;
import org.paneris.melati.boards.model.BoardsDatabaseTables;
import org.paneris.melati.boards.model.BoardsTable;
import org.paneris.melati.boards.model.Message;
import org.paneris.melati.boards.model.User;

public class MessageTableBase<T extends Message>
extends BoardsTable<T> {
    private Column<Integer> col_id = null;
    private Column<Integer> col_board = null;
    private Column<Timestamp> col_date = null;
    private Column<String> col_subject = null;
    private Column<Integer> col_author = null;
    private Column<Integer> col_parent = null;
    private Column<String> col_body = null;
    private Column<Boolean> col_deleted = null;
    private Column<Boolean> col_approved = null;

    public MessageTableBase(Database database, String name, DefinitionSource definitionSource) throws PoemException {
        super(database, name, definitionSource);
    }

    public BoardsDatabaseTables getBoardsDatabaseTables() {
        return (BoardsDatabaseTables)this.getDatabase();
    }

    public void init() throws PoemException {
        super.init();
        this.col_id = new Column<Integer>((Table)this, "id", (SQLPoemType)new TroidPoemType(), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Message)g).getId();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Message)g).setId((Integer)cooked);
            }

            public Field<Integer> asField(Persistent g) {
                return ((Message)g).getIdField();
            }

            public boolean defaultUserEditable() {
                return false;
            }

            public boolean defaultUserCreateable() {
                return false;
            }

            public int defaultDisplayOrder() {
                return 0;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Message)g).getId_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Message)g).setId_unsafe((Integer)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Message)g).getId();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Message)g).setId((Integer)raw);
            }
        };
        this.defineColumn((Column)this.col_id);
        this.col_board = new Column<Integer>((Table)this, "board", (SQLPoemType)new ReferencePoemType(this.getBoardsDatabaseTables().getBoardTable(), false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Message)g).getBoard();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Message)g).setBoard((Board)((Object)cooked));
            }

            public Field<Integer> asField(Persistent g) {
                return ((Message)g).getBoardField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.summary;
            }

            public Searchability defaultSearchability() {
                return Searchability.primary;
            }

            public Integer defaultDisplayOrderPriority() {
                return new Integer(0);
            }

            public int defaultDisplayOrder() {
                return 1;
            }

            public String defaultDescription() {
                return "The board this message belongs to";
            }

            public boolean defaultIndexed() {
                return true;
            }

            public String defaultRenderinfo() {
                return "SelectionWindow";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Message)g).getBoard_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Message)g).setBoard_unsafe((Integer)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Message)g).getBoardTroid();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Message)g).setBoardTroid((Integer)raw);
            }

            public StandardIntegrityFix defaultIntegrityFix() {
                return StandardIntegrityFix.delete;
            }
        };
        this.defineColumn((Column)this.col_board);
        this.col_date = new Column<Timestamp>((Table)this, "date", (SQLPoemType)new TimestampPoemType(false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Message)g).getDate();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Message)g).setDate((Timestamp)cooked);
            }

            public Field<Timestamp> asField(Persistent g) {
                return ((Message)g).getDateField();
            }

            public boolean defaultUserEditable() {
                return false;
            }

            public boolean defaultUserCreateable() {
                return false;
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.summary;
            }

            public Searchability defaultSearchability() {
                return Searchability.no;
            }

            public Integer defaultDisplayOrderPriority() {
                return new Integer(1);
            }

            public boolean defaultSortDescending() {
                return true;
            }

            public int defaultDisplayOrder() {
                return 2;
            }

            public String defaultDescription() {
                return "The date and time at which this message was posted";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Message)g).getDate_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Message)g).setDate_unsafe((Timestamp)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Message)g).getDate();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Message)g).setDate((Timestamp)raw);
            }
        };
        this.defineColumn((Column)this.col_date);
        this.col_subject = new Column<String>((Table)this, "subject", (SQLPoemType)new StringPoemType(false, -1), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Message)g).getSubject();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Message)g).setSubject((String)cooked);
            }

            public Field<String> asField(Persistent g) {
                return ((Message)g).getSubjectField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.primary;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public int defaultDisplayOrder() {
                return 3;
            }

            public String defaultDescription() {
                return "The subject line of this message";
            }

            public int defaultWidth() {
                return 40;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Message)g).getSubject_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Message)g).setSubject_unsafe((String)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Message)g).getSubject();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Message)g).setSubject((String)raw);
            }
        };
        this.defineColumn((Column)this.col_subject);
        this.col_author = new Column<Integer>((Table)this, "author", (SQLPoemType)new ReferencePoemType(this.getBoardsDatabaseTables().getUserTable(), false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Message)g).getAuthor();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Message)g).setAuthor((User)((Object)cooked));
            }

            public Field<Integer> asField(Persistent g) {
                return ((Message)g).getAuthorField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.summary;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public int defaultDisplayOrder() {
                return 4;
            }

            public String defaultDescription() {
                return "Author of this message";
            }

            public String defaultRenderinfo() {
                return "SelectionWindow";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Message)g).getAuthor_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Message)g).setAuthor_unsafe((Integer)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Message)g).getAuthorTroid();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Message)g).setAuthorTroid((Integer)raw);
            }

            public StandardIntegrityFix defaultIntegrityFix() {
                return StandardIntegrityFix.delete;
            }
        };
        this.defineColumn((Column)this.col_author);
        this.col_parent = new Column<Integer>((Table)this, "parent", (SQLPoemType)new ReferencePoemType(this.getBoardsDatabaseTables().getMessageTable(), true), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Message)g).getParent();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Message)g).setParent((Message)((Object)cooked));
            }

            public Field<Integer> asField(Persistent g) {
                return ((Message)g).getParentField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public String defaultDisplayName() {
                return "Parent";
            }

            public int defaultDisplayOrder() {
                return 5;
            }

            public String defaultDescription() {
                return "The message to which this message is a follow-up";
            }

            public boolean defaultIndexed() {
                return true;
            }

            public String defaultRenderinfo() {
                return "SelectionWindow";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Message)g).getParent_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Message)g).setParent_unsafe((Integer)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Message)g).getParentTroid();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Message)g).setParentTroid((Integer)raw);
            }
        };
        this.defineColumn((Column)this.col_parent);
        this.col_body = new Column<String>((Table)this, "body", (SQLPoemType)new StringPoemType(false, -1), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Message)g).getBody();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Message)g).setBody((String)cooked);
            }

            public Field<String> asField(Persistent g) {
                return ((Message)g).getBodyField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Searchability defaultSearchability() {
                return Searchability.yes;
            }

            public int defaultDisplayOrder() {
                return 6;
            }

            public String defaultDescription() {
                return "The main content of this message";
            }

            public int defaultWidth() {
                return 70;
            }

            public int defaultHeight() {
                return 20;
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Message)g).getBody_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Message)g).setBody_unsafe((String)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Message)g).getBody();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Message)g).setBody((String)raw);
            }
        };
        this.defineColumn((Column)this.col_body);
        this.col_deleted = new Column<Boolean>((Table)this, "deleted", (SQLPoemType)new BooleanPoemType(false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Message)g).getDeleted();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Message)g).setDeleted((Boolean)cooked);
            }

            public Field<Boolean> asField(Persistent g) {
                return ((Message)g).getDeletedField();
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Searchability defaultSearchability() {
                return Searchability.no;
            }

            public String defaultDisplayName() {
                return "Deleted";
            }

            public int defaultDisplayOrder() {
                return 7;
            }

            public String defaultDescription() {
                return "A deleted message cannot be viewed or displayed on lists";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Message)g).getDeleted_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Message)g).setDeleted_unsafe((Boolean)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Message)g).getDeleted();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Message)g).setDeleted((Boolean)raw);
            }
        };
        this.defineColumn((Column)this.col_deleted);
        this.col_approved = new Column<Boolean>((Table)this, "approved", (SQLPoemType)new BooleanPoemType(false), DefinitionSource.dsd){

            public Object getCooked(Persistent g) throws AccessPoemException, PoemException {
                return ((Message)g).getApproved();
            }

            public void setCooked(Persistent g, Object cooked) throws AccessPoemException, ValidationPoemException {
                ((Message)g).setApproved((Boolean)cooked);
            }

            public Field<Boolean> asField(Persistent g) {
                return ((Message)g).getApprovedField();
            }

            public boolean defaultUserCreateable() {
                return false;
            }

            public DisplayLevel defaultDisplayLevel() {
                return DisplayLevel.record;
            }

            public Searchability defaultSearchability() {
                return Searchability.no;
            }

            public String defaultDisplayName() {
                return "Approved";
            }

            public int defaultDisplayOrder() {
                return 8;
            }

            public String defaultDescription() {
                return "A message must be approved by a manager of the board before it can be viewed (if the board has moderated postings)";
            }

            public Object getRaw_unsafe(Persistent g) throws AccessPoemException {
                return ((Message)g).getApproved_unsafe();
            }

            public void setRaw_unsafe(Persistent g, Object raw) throws AccessPoemException {
                ((Message)g).setApproved_unsafe((Boolean)raw);
            }

            public Object getRaw(Persistent g) throws AccessPoemException {
                return ((Message)g).getApproved();
            }

            public void setRaw(Persistent g, Object raw) throws AccessPoemException {
                ((Message)g).setApproved((Boolean)raw);
            }
        };
        this.defineColumn((Column)this.col_approved);
    }

    public final Column<Integer> getIdColumn() {
        return this.col_id;
    }

    public final Column<Integer> getBoardColumn() {
        return this.col_board;
    }

    public final Column<Timestamp> getDateColumn() {
        return this.col_date;
    }

    public final Column<String> getSubjectColumn() {
        return this.col_subject;
    }

    public final Column<Integer> getAuthorColumn() {
        return this.col_author;
    }

    public final Column<Integer> getParentColumn() {
        return this.col_parent;
    }

    public final Column<String> getBodyColumn() {
        return this.col_body;
    }

    public final Column<Boolean> getDeletedColumn() {
        return this.col_deleted;
    }

    public final Column<Boolean> getApprovedColumn() {
        return this.col_approved;
    }

    public Message getMessageObject(Integer troid) {
        return (Message)this.getObject(troid);
    }

    public Message getMessageObject(int troid) {
        return (Message)this.getObject(troid);
    }

    protected JdbcPersistent _newPersistent() {
        return new Message();
    }

    public String defaultDescription() {
        return "A message posted to a message board";
    }

    public Integer defaultCacheLimit() {
        return new Integer(2000);
    }

    public String defaultCategory() {
        return "Boards";
    }

    public int defaultDisplayOrder() {
        return 1050;
    }
}

