/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.receivemail;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.melati.poem.AccessPoemException;
import org.melati.poem.Database;
import org.melati.poem.Initialiser;
import org.melati.poem.NoSuchRowPoemException;
import org.melati.poem.Persistent;
import org.melati.poem.ValidationPoemException;
import org.melati.util.ExceptionUtils;
import org.melati.util.IoUtils;
import org.paneris.melati.boards.BoardAdmin;
import org.paneris.melati.boards.model.Attachment;
import org.paneris.melati.boards.model.AttachmentType;
import org.paneris.melati.boards.model.AttachmentTypeTable;
import org.paneris.melati.boards.model.Board;
import org.paneris.melati.boards.model.Message;
import org.paneris.melati.boards.model.MessageTable;
import org.paneris.melati.boards.model.User;
import org.paneris.melati.boards.receivemail.BoardStore;
import org.paneris.melati.boards.receivemail.Log;

public class BoardStoreImpl
implements BoardStore {
    protected Database database;
    protected Log log;
    protected User sender = null;
    protected Recipient recipient = null;
    protected Message parent = null;

    @Override
    public void init(Database db, Log logP, InternetAddress senderAddr, InternetAddress messAddr) throws IOException, MessagingException {
        this.database = db;
        this.log = logP;
        this.recipient = this.recipientOfAddress(messAddr);
        this.sender = this.senderOfAddress(this.recipient, senderAddr);
        if (!this.recipient.board.canPost(this.sender)) {
            throw new MessagingException("user `" + (Object)((Object)this.sender) + "' " + "not authorised to post on this message board");
        }
        if (this.recipient.parentID != null) {
            try {
                this.parent = (Message)this.database.getTable("message").getObject(this.recipient.parentID);
            }
            catch (NoSuchRowPoemException e) {
                throw new MessagingException("parent message `" + this.recipient.parentID + "' " + "not found");
            }
            if (!this.parent.getBoard_unsafe().equals(this.recipient.board.troid())) {
                throw new MessagingException("parent message `" + this.recipient.parentID + "' " + "is not on this board `" + this.recipient.board.getName_unsafe() + "'");
            }
        }
    }

    public void close() {
    }

    protected void finalize() {
        this.close();
    }

    private User senderOfAddress(Recipient to, InternetAddress email) throws MessagingException {
        this.sender = (User)this.database.getTable("user").firstSelection("UPPER(" + this.database.getDbms().getQuotedName("email") + ") = '" + email.getAddress().toUpperCase() + "'");
        if (this.sender == null) {
            if (!to.board.getAnonymousposting().booleanValue()) {
                throw new MessagingException("user `" + email + "' " + "not authorised to post on this message board");
            }
            this.sender = (User)this.database.getUserTable().newPersistent();
            this.sender.setEmail(email.getAddress());
            this.sender.generateDefaults();
            this.database.getUserTable().create((Persistent)this.sender);
        }
        return this.sender;
    }

    @Override
    public org.melati.poem.User getSender() {
        return this.sender;
    }

    public Recipient recipientOfAddress(InternetAddress email) throws MessagingException {
        String boardName;
        int dotIndex;
        String to = email.getAddress();
        Recipient rec = new Recipient();
        int atIndex = to.indexOf(64);
        if (atIndex == -1) {
            atIndex = to.length() - 1;
        }
        if ((dotIndex = to.indexOf(46)) > 0 && dotIndex < atIndex) {
            boardName = to.substring(dotIndex + 1, atIndex);
            try {
                rec.parentID = Integer.valueOf(to.substring(0, dotIndex));
            }
            catch (NumberFormatException e) {
                throw new MessagingException("illegal parent message ID `" + to.substring(0, dotIndex) + "'");
            }
        } else {
            boardName = to.substring(0, atIndex);
            rec.parentID = null;
        }
        Persistent board = this.database.getTable("board").getColumn("name").firstWhereEq((Object)boardName);
        if (board == null) {
            throw new MessagingException("unknown messageboard `" + boardName + "'");
        }
        rec.board = (Board)board;
        return rec;
    }

    protected String attachmentWrite(final Message message, final String fileName, String contentType, final byte[] content) throws Exception {
        if (!((Board)this.database.getTable("board").getObject(message.getBoard_unsafe())).getAttachmentsallowed().booleanValue()) {
            return "[[ Attachments are not allowed on this board ]]\n";
        }
        int semicolonIndex = contentType.indexOf(59);
        if (semicolonIndex != -1) {
            contentType = contentType.substring(0, semicolonIndex);
        }
        final AttachmentType type = ((AttachmentTypeTable)this.database.getTable("attachmenttype")).ensure(contentType);
        Attachment att = (Attachment)this.database.getTable("attachment").create(new Initialiser(){

            public void init(Persistent object) throws AccessPoemException, ValidationPoemException {
                object.setRaw("message", (Object)message.troid());
                ((Attachment)object).setFilename_unique(fileName);
                object.setRaw("size", (Object)new Integer(content.length));
                object.setRaw("type", (Object)type.troid());
            }
        });
        try {
            att.writeData_unsafe(content);
        }
        catch (Exception e) {
            this.log.error("Exception trying to store an attachment:" + ExceptionUtils.stackTrace((Throwable)e));
            att.delete_unsafe();
            return "[[ Attachment `" + fileName + "'could not be saved: " + e.toString() + " ]]\n";
        }
        return "";
    }

    protected Object getContent(MimeMessage message, Part part) throws MessagingException, IOException {
        String[] mailer;
        if (part.getContentType().startsWith("text/plain") && (mailer = message.getHeader("X-Mailer")) != null && mailer.length > 0 && mailer[0].startsWith("Mozilla 4.6")) {
            part.setHeader("Content-Transfer-Encoding", "8bit");
        }
        return part.getContent();
    }

    @Override
    public Integer messageAccept(InputStream text) throws Exception {
        String subject;
        MimeMessage message = new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties(), null), text);
        String string = subject = message.getSubject() == null ? "" : message.getSubject();
        if (subject.toUpperCase().indexOf("BAN") == 0 && this.recipient.board.isManager(this.sender)) {
            this.recipient.board.ban(this.parent.getAuthor());
            this.parent.setDeleted(Boolean.TRUE);
            return null;
        }
        Message m = (Message)((MessageTable)this.database.getTable("message")).create(new Initialiser(){

            public void init(Persistent object) throws AccessPoemException, ValidationPoemException {
                object.setRaw("subject", (Object)subject);
                object.setRaw("board", (Object)BoardStoreImpl.this.recipient.board.getTroid());
                object.setRaw("parent", (Object)BoardStoreImpl.this.recipient.parentID);
                object.setRaw("author", (Object)BoardStoreImpl.this.sender.getTroid());
                object.setRaw("deleted", (Object)Boolean.FALSE);
                object.setRaw("body", (Object)"");
            }
        });
        StringBuffer bodyText = new StringBuffer(100);
        Object content = this.getContent(message, (Part)message);
        if (content instanceof String) {
            bodyText.append((String)content);
        } else if (content instanceof Multipart) {
            Multipart parts = (Multipart)content;
            for (int p = 0; p < parts.getCount(); ++p) {
                Object partContent;
                BodyPart part = parts.getBodyPart(p);
                if (part.getContentType().toLowerCase().indexOf("text/html") != -1 && part.getFileName() == null) {
                    part.setFileName("message-" + m.troid() + ".html");
                }
                if ((partContent = this.getContent(message, (Part)part)) instanceof String && part.getFileName() == null) {
                    bodyText.append((String)partContent);
                    continue;
                }
                bodyText.append(this.attachmentWrite(m, part.getFileName(), part.getContentType(), IoUtils.slurp((InputStream)part.getInputStream(), (int)1024)));
            }
        } else {
            bodyText.append(new String(IoUtils.slurp((InputStream)message.getInputStream(), (int)100)));
        }
        String messageText = bodyText.toString();
        if (messageText.length() > 7168) {
            String attachmentString = this.attachmentWrite(m, "", "truncation", messageText.getBytes());
            messageText = messageText.substring(0, 7168);
            messageText = messageText + "\n\nThis message has been truncated, the complete message has been stored as an attachment.\n" + attachmentString;
        }
        m.setBody(messageText);
        if (m.getApproved().booleanValue()) {
            m.distribute();
        } else {
            BoardAdmin.emailNotification(m.getBoard(), this.sender, "MessageReceived");
        }
        return m.troid();
    }

    public class Recipient {
        public Board board;
        public Integer parentID;
    }
}

