/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.receivemail;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;

public class Redirector
extends Thread {
    private HashMap client = new HashMap();
    private HashMap server = new HashMap();
    private int port = 119;
    private int actualPort = 8119;
    private String host = "localhost";

    public Redirector(int port, int actualPort, String host) {
        this.port = port;
        this.actualPort = actualPort;
        this.host = host;
    }

    private void addPair(SocketChannel clientSC, SocketChannel serverSC) {
        this.client.put(clientSC, serverSC);
        this.server.put(serverSC, clientSC);
    }

    private SocketChannel findPair(SocketChannel other) {
        SocketChannel channel = null;
        channel = (SocketChannel)this.client.get(other);
        if (channel != null) {
            return channel;
        }
        channel = (SocketChannel)this.server.get(other);
        if (channel != null) {
            return channel;
        }
        return null;
    }

    private void removePair(SocketChannel other) throws IOException {
        SocketChannel channel = null;
        channel = (SocketChannel)this.client.remove(other);
        if (channel != null) {
            channel.close();
            this.server.remove(channel);
        }
        if ((channel = (SocketChannel)this.server.remove(other)) != null) {
            this.client.remove(channel);
        }
    }

    @Override
    public void run() {
        try {
            Selector selector = Selector.open();
            ServerSocketChannel ssc = ServerSocketChannel.open();
            ssc.configureBlocking(false);
            InetSocketAddress isa = new InetSocketAddress(this.port);
            ssc.socket().bind(isa);
            ssc.register(selector, 16);
            while (true) {
                try {
                    block7: while (true) {
                        selector.select();
                        Set<SelectionKey> readyKeys = selector.selectedKeys();
                        Iterator<SelectionKey> i = readyKeys.iterator();
                        while (true) {
                            if (!i.hasNext()) continue block7;
                            SelectionKey sk = i.next();
                            i.remove();
                            SelectableChannel nextReady = sk.channel();
                            if (sk.isAcceptable()) {
                                SocketChannel clientChannel = ((ServerSocketChannel)nextReady).accept();
                                clientChannel.configureBlocking(false);
                                SocketChannel serverChannel = null;
                                try {
                                    serverChannel = SocketChannel.open(new InetSocketAddress(this.host, this.actualPort));
                                    serverChannel.configureBlocking(true);
                                    if (serverChannel.finishConnect()) {
                                        serverChannel.configureBlocking(false);
                                        clientChannel.register(selector, 1);
                                        serverChannel.register(selector, 1);
                                        this.addPair(clientChannel, serverChannel);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    System.err.println("Cannot connect to local server");
                                    return;
                                }
                            }
                            if (!sk.isReadable()) continue;
                            ByteBuffer buf = ByteBuffer.allocate(512);
                            SocketChannel another = this.findPair((SocketChannel)nextReady);
                            int read = ((SocketChannel)nextReady).read(buf);
                            if (read > 0) {
                                buf.flip();
                                another.write(buf);
                                continue;
                            }
                            if (read != -1) continue;
                            nextReady.close();
                            another.close();
                            this.removePair(another);
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) {
        int port = 119;
        int actualPort = 8119;
        String host = "localhost";
        if (args.length > 0 && Pattern.matches("[0-9]+", args[0])) {
            port = Integer.parseInt(args[0]);
        }
        if (args.length > 1 && Pattern.matches("[0-9]+", args[1])) {
            actualPort = Integer.parseInt(args[1]);
        }
        if (args.length > 2) {
            host = args[2];
        }
        new Redirector(port, actualPort, host).start();
    }
}

