/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.receivemail;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Properties;
import org.paneris.melati.boards.receivemail.Log;
import org.paneris.melati.boards.receivemail.SMTPServerServlet;
import org.paneris.melati.boards.receivemail.SMTPSession;

public class SMTPServer
implements Runnable {
    private SMTPServerServlet launcher = null;
    final Thread myThread = Thread.currentThread();
    private String smtpIdentifier = null;
    private int port = 1615;
    private Properties databaseNameOfDomain = null;
    private int bufSize = 65536;
    private Log log = null;
    ServerSocket serverSocket;

    public SMTPServer(SMTPServerServlet launcher, String smtpIdentifier, int port, Properties databaseNameOfDomain, int bufSize, Log log) {
        this.launcher = launcher;
        this.smtpIdentifier = smtpIdentifier;
        this.port = port;
        this.databaseNameOfDomain = databaseNameOfDomain;
        this.bufSize = bufSize;
        this.log = log;
    }

    @Override
    public void run() {
        try {
            this.serverSocket = new ServerSocket(this.port);
            while (this.launcher.smtpserverThread == this.myThread) {
                new SMTPSession(this.smtpIdentifier, this.serverSocket.accept(), this.databaseNameOfDomain, this.bufSize, this.log).start();
            }
        }
        catch (Exception e) {
            this.log.exception(e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public synchronized void stop() throws IllegalStateException {
        if (this.myThread == null) {
            throw new IllegalStateException("Server is not running");
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

