/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.receivemail;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.io.Writer;
import java.net.Socket;
import java.sql.SQLException;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.melati.LogicalDatabase;
import org.melati.poem.AccessToken;
import org.melati.poem.Database;
import org.melati.poem.PoemTask;
import org.melati.poem.util.StringUtils;
import org.melati.util.DatabaseInitException;
import org.melati.util.ExceptionUtils;
import org.paneris.melati.boards.receivemail.BoardStore;
import org.paneris.melati.boards.receivemail.DotTerminatedInputStream;
import org.paneris.melati.boards.receivemail.Log;

class SMTPSession
extends Thread {
    private String smtpIdentifier;
    private Socket withClient;
    private PushbackInputStream fromClientPushBack;
    private BufferedReader fromClient;
    private Properties databaseNameOfDomain;
    private int bufSize;
    private PrintWriter toClient;
    private Log log;
    private String sender = null;
    private Database database = null;
    private BoardStore store = null;
    private boolean debug = true;

    SMTPSession(String smtpIdentifier, Socket withClient, Properties databaseNameOfDomain, int buffSize, Log log) throws IOException {
        this.smtpIdentifier = smtpIdentifier;
        this.withClient = withClient;
        this.databaseNameOfDomain = databaseNameOfDomain;
        this.bufSize = buffSize;
        this.log = log;
        this.fromClientPushBack = new PushbackInputStream(new BufferedInputStream(withClient.getInputStream(), this.bufSize));
        this.fromClient = new BufferedReader(new InputStreamReader(this.fromClientPushBack));
        this.toClient = new PrintWriter((Writer)new OutputStreamWriter(withClient.getOutputStream(), "8859_1"), true);
    }

    private void reset() {
        this.sender = null;
        this.database = null;
        this.store = null;
    }

    private void output(String s) {
        this.toClient.println(s);
        if (this.debug) {
            this.log.debug(s);
        }
    }

    private void mailFrom(String address) {
        if (address.charAt(0) == '<') {
            address = address.substring(1, address.length() - 1);
        }
        this.sender = address;
        this.output("250 " + address + "... Sender provisionally OK");
    }

    private Database databaseForAddress(String address) throws MessagingException, IOException {
        int atIndex = address.indexOf(64);
        if (atIndex == -1) {
            throw new MessagingException("`" + address + "': missing domain, " + "so can't determine which database to use");
        }
        String domain = address.substring(atIndex + 1);
        String propertyName = "org.paneris.melati.boards.receivemail.database." + domain;
        String databaseName = this.databaseNameOfDomain.getProperty(propertyName);
        if (databaseName == null) {
            throw new MessagingException("`" + domain + "' is not a board mail domain " + "(no entry `" + propertyName + "' in properties)");
        }
        try {
            return LogicalDatabase.getDatabase((String)databaseName);
        }
        catch (DatabaseInitException e) {
            throw new IOException("failed to open database `" + domain + "' -> `" + databaseName + "': " + (Object)((Object)e));
        }
    }

    private void rcptTo(String address) throws Exception {
        if (this.sender == null) {
            this.output("503 Need MAIL before RCPT");
        } else if (this.database != null) {
            this.output("553 a message can only appear on one board, but this one was copied to several");
        } else {
            if (address.charAt(0) == '<') {
                address = address.substring(1, address.length() - 1);
            }
            final String address1 = address;
            final String sender1 = this.sender;
            try {
                this.database = this.databaseForAddress(address1);
            }
            catch (MessagingException e) {
                this.output("550 " + StringUtils.tr((String)e.getMessage(), (String)"\n\r", (String)"  "));
                this.log.warning("board address `" + address1 + "' rejected: " + (Object)((Object)e));
                return;
            }
            this.database.inSession(AccessToken.root, new PoemTask(){

                public void run() {
                    try {
                        String boardStoreImpl = SMTPSession.this.databaseNameOfDomain.getProperty("org.paneris.melati.boards.receivemail.BoardStoreImpl");
                        Class<?> clazz = null;
                        try {
                            clazz = Class.forName(boardStoreImpl);
                        }
                        catch (Exception e) {
                            SMTPSession.this.log.error("Unable to load board store: " + boardStoreImpl);
                            SMTPSession.this.log.exception(e);
                            clazz = Class.forName("org.paneris.melati.boards.receivemail.BoardStoreImpl");
                        }
                        SMTPSession.this.store = (BoardStore)clazz.newInstance();
                        SMTPSession.this.store.init(SMTPSession.this.database, SMTPSession.this.log, new InternetAddress(sender1), new InternetAddress(address1));
                        SMTPSession.this.output("250 Recipient OK");
                    }
                    catch (MessagingException e) {
                        SMTPSession.this.output("550 " + StringUtils.tr((String)e.getMessage(), (String)"\n\r", (String)"  "));
                        SMTPSession.this.log.warning("board address `" + address1 + "' rejected: " + (Object)((Object)e));
                        SMTPSession.this.database = null;
                    }
                    catch (Exception e) {
                        SMTPSession.this.output("554 Sorry: something is wrong with this server---" + StringUtils.tr((String)e.toString(), (String)"\n\r", (String)"  "));
                        SMTPSession.this.log.error("post of message from `" + sender1 + "' failed:\n" + ExceptionUtils.stackTrace((Throwable)e));
                        SMTPSession.this.database = null;
                    }
                }
            });
        }
    }

    private void data() {
        if (this.store == null) {
            this.output("503 Need MAIL command");
        } else {
            this.output("354 Enter mail, end with \".\" on a line by itself");
            this.database.inSession((AccessToken)this.store.getSender(), new PoemTask(){

                public void run() {
                    try {
                        Integer messageID = SMTPSession.this.store.messageAccept(new DotTerminatedInputStream(SMTPSession.this.fromClientPushBack));
                        SMTPSession.this.output("250 " + messageID + " Message accepted for delivery");
                    }
                    catch (SQLException e) {
                        if (e.getMessage().startsWith("SQL Statement too long")) {
                            SMTPSession.this.output("552 Your message message is too long---can you split it up?");
                            SMTPSession.this.reset();
                        } else {
                            SMTPSession.this.output("554 Sorry: something is wrong with this server---" + StringUtils.tr((String)e.toString(), (String)"\n\r", (String)"  "));
                            SMTPSession.this.log.error("Exception trying to store a message:" + ExceptionUtils.stackTrace((Throwable)e));
                            SMTPSession.this.reset();
                        }
                    }
                    catch (Exception e) {
                        SMTPSession.this.output("554 Sorry!!!: something is wrong with this server---" + StringUtils.tr((String)e.toString(), (String)"\n\r", (String)"  "));
                        SMTPSession.this.log.error("Exception trying to store a message:" + ExceptionUtils.stackTrace((Throwable)e));
                        SMTPSession.this.reset();
                    }
                }
            });
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.output("220 " + this.smtpIdentifier + " SMTP");
            while (true) {
                String command;
                if ((command = this.fromClient.readLine().trim()).regionMatches(true, 0, "HELO", 0, 4)) {
                    this.output("250 " + this.smtpIdentifier);
                    continue;
                }
                if (command.regionMatches(true, 0, "MAIL FROM:", 0, 10)) {
                    this.mailFrom(command.substring(10).trim());
                    continue;
                }
                if (command.regionMatches(true, 0, "RCPT TO:", 0, 8)) {
                    this.rcptTo(command.substring(8).trim());
                    continue;
                }
                if (command.regionMatches(true, 0, "DATA", 0, 4)) {
                    this.data();
                    continue;
                }
                if (command.regionMatches(true, 0, "RSET", 0, 4)) {
                    this.reset();
                    this.output("250 Reset state");
                    continue;
                }
                if (command.regionMatches(true, 0, "QUIT", 0, 4)) {
                    this.output("221 " + this.smtpIdentifier + " closing connection");
                    break;
                }
                this.output("500 Command unrecognized: \"" + command + "\"");
            }
        }
        catch (Exception e) {
            this.output("554 Sorry: something is wrong with this server---" + StringUtils.tr((String)e.toString(), (String)"\n\r", (String)"  "));
            if (this.sender != null) {
                this.log.error("post of message from `" + this.sender + "' failed:\n" + ExceptionUtils.stackTrace((Throwable)e));
            } else {
                this.log.error("post of message failed before user established:\n" + ExceptionUtils.stackTrace((Throwable)e));
            }
        }
        finally {
            try {
                this.reset();
                this.withClient.close();
            }
            catch (Exception exception) {}
        }
    }
}

