/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.boards.receivemail.nntp;

import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;
import org.melati.LogicalDatabase;
import org.melati.poem.AccessPoemException;
import org.melati.poem.Initialiser;
import org.melati.poem.Persistent;
import org.melati.poem.PoemDatabase;
import org.melati.poem.ValidationPoemException;
import org.melati.util.ExceptionUtils;
import org.melati.util.IoUtils;
import org.paneris.melati.boards.BoardAdmin;
import org.paneris.melati.boards.model.Attachment;
import org.paneris.melati.boards.model.AttachmentType;
import org.paneris.melati.boards.model.Board;
import org.paneris.melati.boards.model.BoardsDatabaseTables;
import org.paneris.melati.boards.model.Message;
import org.paneris.melati.boards.model.MessageTable;
import org.paneris.melati.boards.model.User;
import org.paneris.melati.boards.receivemail.Log;
import org.paneris.melati.boards.receivemail.nntp.NNTPMessage;
import org.paneris.melati.boards.receivemail.nntp.NNTPSession;
import org.paneris.melati.boards.receivemail.nntp.UnknownNewsGroupException;

public class NNTPStore {
    private Log log;
    private BoardsDatabaseTables db = null;
    String prefix = null;
    String msgIdSuffix = null;

    private NNTPStore() {
    }

    public NNTPStore(String database, String prefix, String nntpIdentifier) throws Exception {
        this.db = (BoardsDatabaseTables)LogicalDatabase.getDatabase((String)database);
        ((PoemDatabase)this.db).setLogSQL(false);
        this.prefix = prefix;
        this.msgIdSuffix = "$msg@" + nntpIdentifier;
    }

    public BoardsDatabaseTables getDb() {
        return this.db;
    }

    public Board getBoard(String name) throws AccessPoemException, UnknownNewsGroupException {
        return this.resolveTargetBoard(name);
    }

    private String formatTimestamp(Date date) {
        String dbmsClassName = ((PoemDatabase)this.db).getDbms().getClass().getName();
        if (dbmsClassName.indexOf("Postgresql") != -1) {
            return "'" + new SimpleDateFormat("MM-dd-yyyy HH:mm:ss Z").format(date) + "'";
        }
        if (dbmsClassName.indexOf("SQLServer") != -1) {
            return "'" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S").format(date) + "'";
        }
        return "'" + new Timestamp(date.getTime()).toString() + "'";
    }

    public Enumeration getBoards(Date from, String wildmat) {
        try {
            String criteria = null;
            Enumeration result = null;
            if (from != null) {
                String boardColName = this.db.getMessageTable().getBoardColumn().quotedName();
                String msgTableName = this.db.getMessageTable().getName();
                String dateColName = this.db.getMessageTable().getDateColumn().quotedName();
                String troidColName = this.db.getBoardTable().troidColumn().quotedName();
                criteria = troidColName + " in (SELECT " + boardColName + " FROM " + msgTableName + " WHERE " + dateColName + " >= " + this.formatTimestamp(from) + ")";
                result = this.db.getBoardTable().selection(criteria);
            } else {
                result = this.db.getBoardTable().selection();
            }
            if (wildmat != null) {
                Pattern p = new GlobCompiler().compile(wildmat);
                Perl5Matcher matcher = new Perl5Matcher();
                Vector<Board> boards = new Vector<Board>();
                while (result.hasMoreElements()) {
                    Board element = (Board)((Object)result.nextElement());
                    if (!matcher.matches(this.prefix + "." + element.getName(), p)) continue;
                    boards.add(element);
                }
                result = boards.elements();
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Enumeration getRange(String range, Board selectedBoard) throws SQLException {
        if (selectedBoard == null) {
            return null;
        }
        if (range == null) {
            range = "" + selectedBoard.getFirstMessageId();
        }
        if (range.startsWith("<")) {
            return null;
        }
        int start = -1;
        int end = -1;
        int idx = range.indexOf(45);
        if (idx == -1) {
            end = start = Integer.parseInt(range) - 1;
        } else {
            start = Integer.parseInt(range.substring(0, idx)) - 1;
            end = idx + 1 == range.length() ? selectedBoard.getLastMessageId() : Integer.parseInt(range.substring(idx + 1)) - 1;
        }
        MessageTable messageTable = (MessageTable)selectedBoard.getDatabase().getTable("message");
        Enumeration result = messageTable.selection(messageTable.troidColumn().quotedName() + " BETWEEN " + start + " AND " + end + " AND " + messageTable.getBoardColumn().quotedName() + " = " + selectedBoard.getTroid());
        return result;
    }

    String getReferences(Message msg) {
        String references = "";
        Message parent = msg.getParent();
        if (parent != null) {
            references = this.getArticleId(new NNTPMessage(parent).getNntpIdInt());
        }
        return references;
    }

    public void xpat(String header, String range, String wildmat, String selectedGroup, PrintWriter writer) {
        try {
            Pattern p = new GlobCompiler().compile(wildmat);
            Perl5Matcher matcher = new Perl5Matcher();
            Board brd = this.resolveTargetBoard(selectedGroup);
            Enumeration messages = this.getRange(range, brd);
            writer.println("221 " + header + " matches follow");
            if (messages != null) {
                while (messages.hasMoreElements()) {
                    Message msg = (Message)((Object)messages.nextElement());
                    NNTPMessage nntpMsg = new NNTPMessage(msg);
                    boolean matched = false;
                    String matchedHeader = null;
                    if ("subject".equalsIgnoreCase(header)) {
                        matchedHeader = msg.getSubject();
                        matched = matcher.matches(matchedHeader, p);
                    } else if ("from".equalsIgnoreCase(header)) {
                        matchedHeader = nntpMsg.getFrom();
                        matched = matcher.matches(matchedHeader, p);
                    } else {
                        matched = false;
                    }
                    if (!matched) continue;
                    writer.println(nntpMsg.getNntpId() + " " + matchedHeader);
                }
            }
            writer.println(".");
        }
        catch (AccessPoemException e) {
            writer.println("502 no permission");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Board resolveTargetBoard(String newsGroup) throws UnknownNewsGroupException {
        if (!newsGroup.startsWith(this.prefix)) {
            throw new UnknownNewsGroupException("Expecting newsgroup name to start with:'" + this.prefix + "'");
        }
        String boardName = newsGroup.substring(this.prefix.length() + 1).trim();
        return (Board)this.db.getBoardTable().getColumn("name").firstWhereEq((Object)boardName);
    }

    public void establishUser(NNTPSession.AuthInfo authInfo) {
        User user = null;
        try {
            user = (User)this.db.getUserTable().getColumn("login").firstWhereEq((Object)authInfo.getLogin());
            if (user != null && user.getPassword_unsafe().equals(authInfo.getPassword())) {
                authInfo.setUser(user);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public NNTPMessage getArticle(int id) throws AccessPoemException {
        int troid = id - 1;
        Message message = null;
        try {
            message = (Message)this.db.getMessageTable().firstSelection(this.db.getMessageTable().troidColumn().quotedName() + "=" + troid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new NNTPMessage(message);
    }

    public String getArticleId(int id) {
        return "<" + id + this.msgIdSuffix + ">";
    }

    protected String attachmentWrite(final Message message, final String fileName, String contentType, final byte[] content) throws Exception {
        if (!((Board)this.db.getBoardTable().getObject(message.getBoard_unsafe())).getAttachmentsallowed().booleanValue()) {
            return "[[ Attachments are not allowed on this board ]]\n";
        }
        int semicolonIndex = contentType.indexOf(59);
        if (semicolonIndex != -1) {
            contentType = contentType.substring(0, semicolonIndex);
        }
        final AttachmentType type = this.db.getAttachmentTypeTable().ensure(contentType);
        Attachment att = (Attachment)this.db.getAttachmentTable().create(new Initialiser(){

            public void init(Persistent object) throws AccessPoemException, ValidationPoemException {
                object.setRaw("message", (Object)message.troid());
                ((Attachment)object).setFilename_unique(fileName);
                object.setRaw("size", (Object)new Integer(content.length));
                object.setRaw("type", (Object)type.troid());
            }
        });
        try {
            att.writeData_unsafe(content);
        }
        catch (Exception e) {
            this.log.error("Exception trying to store an attachment:" + ExceptionUtils.stackTrace((Throwable)e));
            att.delete_unsafe();
            return "[[ Attachment `" + fileName + "'could not be saved: " + e.toString() + " ]]\n";
        }
        return "";
    }

    public void postMessage(final MimeMessage message, final User sender) throws Exception {
        String newsgroups = message.getHeader("newsgroups")[0];
        if (newsgroups == null) {
            throw new Exception("newsgroups header missing");
        }
        StringTokenizer strtok = new StringTokenizer(newsgroups, ", ", false);
        final Board board = this.resolveTargetBoard(strtok.nextToken());
        try {
            final String subject = message.getSubject();
            Message m = (Message)this.db.getMessageTable().create(new Initialiser(){

                public void init(Persistent object) throws AccessPoemException, ValidationPoemException {
                    object.setRaw("subject", (Object)subject);
                    object.setRaw("board", (Object)board.getTroid());
                    Integer parent = null;
                    try {
                        String[] refs = message.getHeader("references");
                        if (refs != null) {
                            StringTokenizer refsTok = new StringTokenizer(refs[0], "<> \t", false);
                            int count = refsTok.countTokens();
                            for (int i = 1; i <= count; ++i) {
                                String ref = refsTok.nextToken();
                                if (i != count) continue;
                                parent = new Integer(Integer.decode(ref.substring(0, ref.indexOf(36))) - 1);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    object.setRaw("parent", parent);
                    object.setRaw("author", (Object)sender.getTroid());
                    object.setRaw("deleted", (Object)Boolean.FALSE);
                    object.setRaw("body", (Object)"");
                }
            });
            try {
                System.err.println(message.getContentType());
                Object content = message.getContent();
                StringBuffer bodyText = new StringBuffer(100);
                if (content instanceof String) {
                    bodyText.append((String)content);
                    System.err.println("content is string");
                } else if (content instanceof Multipart) {
                    System.err.println("content is multipart");
                    Multipart parts = (Multipart)content;
                    for (int p = 0; p < parts.getCount(); ++p) {
                        BodyPart part = parts.getBodyPart(p);
                        Object partContent = part.getContent();
                        if (partContent instanceof String && part.getFileName() == null) {
                            bodyText.append((String)partContent);
                            continue;
                        }
                        bodyText.append(this.attachmentWrite(m, part.getFileName(), part.getContentType(), IoUtils.slurp((InputStream)part.getInputStream(), (int)1024)));
                    }
                } else {
                    System.err.println(content.getClass().getName());
                    System.err.println("one nontext item");
                    bodyText.append(new String(IoUtils.slurp((InputStream)message.getInputStream(), (int)100)));
                }
                String messageText = bodyText.toString();
                if (messageText.length() > 7168) {
                    String attachmentString = this.attachmentWrite(m, "", "truncation", messageText.getBytes());
                    messageText = messageText.substring(0, 7168);
                    messageText = messageText + "\n\nThis message has been truncated, the complete message has been stored as an attachment.\n" + attachmentString;
                }
                m.setBody(messageText);
                if (m.getApproved().booleanValue()) {
                    m.distribute();
                } else {
                    BoardAdmin.emailNotification(m.getBoard(), sender, "MessageReceived");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        catch (AccessPoemException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

