// Do not edit this file!  It was generated by Melati POEM's DSD preprocessor.

package org.paneris.melati.site.model.generated;


import java.sql.Timestamp;
import org.melati.poem.AccessPoemException;
import org.melati.poem.BooleanPoemType;
import org.melati.poem.Column;
import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.DeletedPoemType;
import org.melati.poem.DisplayLevel;
import org.melati.poem.Field;
import org.melati.poem.IntegerPoemType;
import org.melati.poem.JdbcPersistent;
import org.melati.poem.Persistent;
import org.melati.poem.PoemException;
import org.melati.poem.ReferencePoemType;
import org.melati.poem.Searchability;
import org.melati.poem.StringPoemType;
import org.melati.poem.TimestampPoemType;
import org.melati.poem.TroidPoemType;
import org.melati.poem.ValidationPoemException;
import org.paneris.melati.site.model.Page;
import org.paneris.melati.site.model.SiteDatabaseTables;
import org.paneris.melati.site.model.SiteTable;
import org.paneris.melati.site.model.Style;
import org.paneris.melati.site.model.Template;


/**
 * Melati POEM generated base class for 
<code>Table</code> <code>Page</code>.
 *
 * see org.melati.poem.prepro.TableDef#generateTableBaseJava 
 */

public class PageTableBase extends SiteTable {

  private Column<Integer> col_id = null;
  private Column<String> col_name = null;
  private Column<String> col_displayname = null;
  private Column<Integer> col_displayorder = null;
  private Column<Boolean> col_display = null;
  private Column<Boolean> col_deleted = null;
  private Column<Timestamp> col_lastencached = null;
  private Column<Integer> col_parent = null;
  private Column<Integer> col_template = null;
  private Column<Integer> col_style = null;

 /**
  * Constructor. 
  * 
  * see org.melati.poem.prepro.TableDef#generateTableBaseJava 
  * @param database          the POEM database we are using
  * @param name              the name of this <code>Table</code>
  * @param definitionSource  which definition is being used
  * @throws PoemException    if anything goes wrong
  */

  public PageTableBase(
      Database database, String name,
      DefinitionSource definitionSource) throws PoemException {
    super(database, name, definitionSource);
  }


 /**
  * Get the database tables.
  *
  * see org.melati.poem.prepro.TableDef#generateTableBaseJava 
  * @return the database tables
  */
  public SiteDatabaseTables getSiteDatabaseTables() {
    return (SiteDatabaseTables)getDatabase();
  }

  public void init() throws PoemException {
    super.init();
    defineColumn(col_id =
        new Column<Integer>(this, "id",
                   new TroidPoemType(),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((Page)g).getId();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((Page)g).setId((Integer)cooked);
          }

          public Field<Integer> asField(Persistent g) {
            return ((Page)g).getIdField();
          }

          protected boolean defaultUserEditable() {
            return false;
          }

          protected boolean defaultUserCreateable() {
            return false;
          }

          protected DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.record;
          }

          protected Searchability defaultSearchability() {
            return Searchability.no;
          }

          protected int defaultDisplayOrder() {
            return 0;
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getId_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setId_unsafe((Integer)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getId();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setId((Integer)raw);
          }
        });

    defineColumn(col_name =
        new Column<String>(this, "name",
                   new StringPoemType(false, -1),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((Page)g).getName();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((Page)g).setName((String)cooked);
          }

          public Field<String> asField(Persistent g) {
            return ((Page)g).getNameField();
          }

          protected DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.record;
          }

          protected int defaultDisplayOrder() {
            return 1;
          }

          protected String defaultDescription() {
            return "A file system name, no spaces or special characters";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getName_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setName_unsafe((String)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getName();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setName((String)raw);
          }
        });

    defineColumn(col_displayname =
        new Column<String>(this, "displayname",
                   new StringPoemType(false, -1),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((Page)g).getDisplayname();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((Page)g).setDisplayname((String)cooked);
          }

          public Field<String> asField(Persistent g) {
            return ((Page)g).getDisplaynameField();
          }

          protected DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.primary;
          }

          protected Searchability defaultSearchability() {
            return Searchability.primary;
          }

          protected String defaultDisplayName() {
            return "Display Name";
          }

          protected int defaultDisplayOrder() {
            return 2;
          }

          protected String defaultDescription() {
            return "The full name used in the TITLE.";
          }

          protected boolean defaultUnique() {
            return true;
          }

          protected int defaultWidth() {
            return 20;
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getDisplayname_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setDisplayname_unsafe((String)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getDisplayname();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setDisplayname((String)raw);
          }
        });

    defineColumn(col_displayorder =
        new Column<Integer>(this, "displayorder",
                   new IntegerPoemType(false),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((Page)g).getDisplayorder();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((Page)g).setDisplayorder((Integer)cooked);
          }

          public Field<Integer> asField(Persistent g) {
            return ((Page)g).getDisplayorderField();
          }

          protected DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.record;
          }

          protected Integer defaultDisplayOrderPriority() {
            return new Integer(0);
          }

          protected String defaultDisplayName() {
            return "Display order";
          }

          protected int defaultDisplayOrder() {
            return 3;
          }

          protected String defaultDescription() {
            return "A rank determining where the page appears in a list";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getDisplayorder_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setDisplayorder_unsafe((Integer)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getDisplayorder();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setDisplayorder((Integer)raw);
          }
        });

    defineColumn(col_display =
        new Column<Boolean>(this, "display",
                   new BooleanPoemType(false),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((Page)g).getDisplay();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((Page)g).setDisplay((Boolean)cooked);
          }

          public Field<Boolean> asField(Persistent g) {
            return ((Page)g).getDisplayField();
          }

          protected DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.record;
          }

          protected Searchability defaultSearchability() {
            return Searchability.yes;
          }

          protected int defaultDisplayOrder() {
            return 4;
          }

          protected String defaultDescription() {
            return "Whether to display this page";
          }

          protected boolean defaultIndexed() {
            return true;
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getDisplay_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setDisplay_unsafe((Boolean)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getDisplay();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setDisplay((Boolean)raw);
          }
        });

    defineColumn(col_deleted =
        new Column<Boolean>(this, "deleted",
                   new DeletedPoemType(),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((Page)g).getDeleted();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((Page)g).setDeleted((Boolean)cooked);
          }

          public Field<Boolean> asField(Persistent g) {
            return ((Page)g).getDeletedField();
          }

          protected DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.detail;
          }

          protected Searchability defaultSearchability() {
            return Searchability.no;
          }

          protected int defaultDisplayOrder() {
            return 5;
          }

          protected String defaultDescription() {
            return "Soft delete";
          }

          protected boolean defaultIndexed() {
            return true;
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getDeleted_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setDeleted_unsafe((Boolean)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getDeleted();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setDeleted((Boolean)raw);
          }
        });

    defineColumn(col_lastencached =
        new Column<Timestamp>(this, "lastencached",
                   new TimestampPoemType(true),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((Page)g).getLastencached();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((Page)g).setLastencached((Timestamp)cooked);
          }

          public Field<Timestamp> asField(Persistent g) {
            return ((Page)g).getLastencachedField();
          }

          protected DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.record;
          }

          protected String defaultDisplayName() {
            return "Last encached";
          }

          protected int defaultDisplayOrder() {
            return 1000;
          }

          protected String defaultDescription() {
            return "When the page was encached; cleared when the page is updated";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getLastencached_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setLastencached_unsafe((Timestamp)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getLastencached();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setLastencached((Timestamp)raw);
          }
        });

    defineColumn(col_parent =
        new Column<Integer>(this, "parent",
                   new ReferencePoemType(getSiteDatabaseTables().
                                             getPageTable(), true),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((Page)g).getParent();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((Page)g).setParent((Page)cooked);
          }

          public Field<Integer> asField(Persistent g) {
            return ((Page)g).getParentField();
          }

          protected DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.summary;
          }

          protected Searchability defaultSearchability() {
            return Searchability.yes;
          }

          protected int defaultDisplayOrder() {
            return 1001;
          }

          protected String defaultDescription() {
            return "The parent page (empty for Home). ";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getParent_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setParent_unsafe((Integer)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getParentTroid();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setParentTroid((Integer)raw);
          }
        });

    defineColumn(col_template =
        new Column<Integer>(this, "template",
                   new ReferencePoemType(getSiteDatabaseTables().
                                             getTemplateTable(), true),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((Page)g).getTemplate();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((Page)g).setTemplate((Template)cooked);
          }

          public Field<Integer> asField(Persistent g) {
            return ((Page)g).getTemplateField();
          }

          protected DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.record;
          }

          protected int defaultDisplayOrder() {
            return 1002;
          }

          protected String defaultDescription() {
            return "The name of the layout for this page";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getTemplate_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setTemplate_unsafe((Integer)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getTemplateTroid();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setTemplateTroid((Integer)raw);
          }
        });

    defineColumn(col_style =
        new Column<Integer>(this, "style",
                   new ReferencePoemType(getSiteDatabaseTables().
                                             getStyleTable(), true),
                   DefinitionSource.dsd) { 
          public Object getCooked(Persistent g)
              throws AccessPoemException, PoemException {
            return ((Page)g).getStyle();
          }

          public void setCooked(Persistent g, Object cooked)
              throws AccessPoemException, ValidationPoemException {
            ((Page)g).setStyle((Style)cooked);
          }

          public Field<Integer> asField(Persistent g) {
            return ((Page)g).getStyleField();
          }

          protected DisplayLevel defaultDisplayLevel() {
            return DisplayLevel.record;
          }

          protected int defaultDisplayOrder() {
            return 1003;
          }

          protected String defaultDescription() {
            return "The name of the CSS class for this page";
          }

          public Object getRaw_unsafe(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getStyle_unsafe();
          }

          public void setRaw_unsafe(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setStyle_unsafe((Integer)raw);
          }

          public Object getRaw(Persistent g)
              throws AccessPoemException {
            return ((Page)g).getStyleTroid();
          }

          public void setRaw(Persistent g, Object raw)
              throws AccessPoemException {
            ((Page)g).setStyleTroid((Integer)raw);
          }
        });
  }


 /**
  * Retrieves the <code>Id</code> <code>Column</code> for this 
  * <code>Page</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the id <code>Column</code>
  */
  public final Column<Integer> getIdColumn() {
    return col_id;
  }


 /**
  * Retrieves the <code>Name</code> <code>Column</code> for this 
  * <code>Page</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the name <code>Column</code>
  */
  public final Column<String> getNameColumn() {
    return col_name;
  }


 /**
  * Retrieves the <code>Displayname</code> <code>Column</code> for this 
  * <code>Page</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the displayname <code>Column</code>
  */
  public final Column<String> getDisplaynameColumn() {
    return col_displayname;
  }


 /**
  * Retrieves the <code>Displayorder</code> <code>Column</code> for this 
  * <code>Page</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the displayorder <code>Column</code>
  */
  public final Column<Integer> getDisplayorderColumn() {
    return col_displayorder;
  }


 /**
  * Retrieves the <code>Display</code> <code>Column</code> for this 
  * <code>Page</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the display <code>Column</code>
  */
  public final Column<Boolean> getDisplayColumn() {
    return col_display;
  }


 /**
  * Retrieves the <code>Deleted</code> <code>Column</code> for this 
  * <code>Page</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the deleted <code>Column</code>
  */
  public final Column<Boolean> getDeletedColumn() {
    return col_deleted;
  }


 /**
  * Retrieves the <code>Lastencached</code> <code>Column</code> for this 
  * <code>Page</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the lastencached <code>Column</code>
  */
  public final Column<Timestamp> getLastencachedColumn() {
    return col_lastencached;
  }


 /**
  * Retrieves the <code>Parent</code> <code>Column</code> for this 
  * <code>Page</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the parent <code>Column</code>
  */
  public final Column<Integer> getParentColumn() {
    return col_parent;
  }


 /**
  * Retrieves the <code>Template</code> <code>Column</code> for this 
  * <code>Page</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the template <code>Column</code>
  */
  public final Column<Integer> getTemplateColumn() {
    return col_template;
  }


 /**
  * Retrieves the <code>Style</code> <code>Column</code> for this 
  * <code>Page</code> <code>Table</code>.
  * 
  * see org.melati.poem.prepro.FieldDef#generateColAccessor 
  * @return the style <code>Column</code>
  */
  public final Column<Integer> getStyleColumn() {
    return col_style;
  }


 /**
  * Retrieve the <code>Page</code> as a <code>Page</code>.
  *
  * see org.melati.poem.prepro.TableDef#generateTableBaseJava 
  * @param troid a Table Row Oject ID
  * @return the <code>Persistent</code> identified by the <code>troid</code>
  */
  public Page getPageObject(Integer troid) {
    return (Page)getObject(troid);
  }


 /**
  * Retrieve the <code>Page</code> 
  * as a <code>Page</code>.
  *
  * see org.melati.poem.prepro.TableDef#generateTableBaseJava 
  * @param troid a Table Row Object ID
  * @return the <code>Persistent</code> identified   */
  public Page getPageObject(int troid) {
    return (Page)getObject(troid);
  }

  protected JdbcPersistent _newPersistent() {
    return new Page();
  }
  protected String defaultDescription() {
    return "A Page";
  }

  protected boolean defaultRememberAllTroids() {
    return true;
  }

  protected String defaultCategory() {
    return "Data";
  }

  protected int defaultDisplayOrder() {
    return 200;
  }
}

