/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.site;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import org.melati.Melati;
import org.melati.PoemContext;
import org.melati.poem.Column;
import org.melati.poem.Persistent;
import org.melati.poem.Table;
import org.melati.poem.util.StringUtils;
import org.melati.servlet.PathInfoException;
import org.melati.servlet.TemplateServlet;
import org.melati.template.ServletTemplateContext;

public abstract class SiteServlet
extends TemplateServlet {
    private static final long serialVersionUID = 2807149216380558185L;
    public static final boolean DEBUG = true;
    private static final String STATIC_ROOT = "/dist/MelatiSite/src/main/webapp";
    private static final String DB_NAME = "site";

    protected void doConfiguredRequest(Melati melati) throws ServletException, IOException {
        String pathInfo = this.getPathInfo(melati);
        System.err.println("pathinfo:" + pathInfo);
        while (pathInfo != "" && !this.fileAt(pathInfo)) {
            String s = pathInfo.substring(1);
            int i = s.indexOf(47);
            if (i == -1) {
                pathInfo = "";
                continue;
            }
            pathInfo = s.substring(i);
        }
        if (pathInfo != "") {
            System.err.println("pathinfo:" + pathInfo);
            System.err.println("Ref:" + melati.getRequest().getHeader("Referer"));
            StringBuffer url = new StringBuffer();
            String scheme = melati.getRequest().getScheme();
            url.append(scheme);
            url.append("://");
            url.append(melati.getRequest().getServerName());
            url.append(pathInfo);
            melati.getResponse().sendRedirect(url.toString());
            return;
        }
        super.doConfiguredRequest(melati);
        melati.setResponseContentType("text/html");
    }

    protected boolean fileAt(String filename) {
        if (filename.equals("")) {
            return false;
        }
        if (filename.equals("/")) {
            return false;
        }
        String fsName = this.getSTATIC_ROOT() + filename;
        File it = new File(fsName);
        System.err.println("FS:" + fsName + " " + it.exists());
        return it.exists();
    }

    protected String doTemplateRequest(Melati melati, ServletTemplateContext context) throws Exception {
        return melati.templateName(this.reallyDoTemplateRequest(melati, context));
    }

    protected abstract String reallyDoTemplateRequest(Melati var1, ServletTemplateContext var2) throws Exception;

    protected String getSetting(Melati melati, String settingName) {
        String returnString = melati.getDatabase().getSettingTable().get(settingName);
        if (returnString == null) {
            throw new RuntimeException("Setting " + settingName + " not found in setting table");
        }
        return returnString;
    }

    protected PoemContext poemContext(Melati melati) throws PathInfoException {
        String[] parts;
        PoemContext it = new PoemContext();
        it.setLogicalDatabase(this.getDB_NAME());
        String initParameterPathInfo = this.getInitParameter("pathinfo");
        if (initParameterPathInfo != null) {
            parts = StringUtils.split((String)initParameterPathInfo, (char)'/');
            System.err.println("Got init param:" + initParameterPathInfo);
        } else {
            System.err.println("Did not find init param");
            parts = melati.getPathInfoParts();
        }
        if (parts.length > 0) {
            if (parts.length == 1) {
                it.setMethod(parts[0]);
            }
            if (parts.length == 2) {
                String r = parts[1];
                if (r.lastIndexOf(".htm") != -1) {
                    r = r.substring(0, r.lastIndexOf(".htm"));
                }
                it.setTable(parts[0]);
                try {
                    it.setTroid(new Integer(r));
                }
                catch (NumberFormatException e) {
                    it.setMethod(parts[1]);
                }
            }
            if (parts.length == 3) {
                block13: {
                    it.setTable(parts[0]);
                    try {
                        it.setTroid(new Integer(parts[1]));
                    }
                    catch (NumberFormatException e) {
                        String r = parts[1];
                        if (r.lastIndexOf(".htm") != -1) {
                            r = r.substring(0, r.lastIndexOf(".htm"));
                        }
                        String value = r.replace('.', ' ').replace('_', ' ');
                        Table t = melati.getTable();
                        if (t == null) break block13;
                        Column c = t.primaryCriterionColumn();
                        if (c == null) {
                            throw new NullPointerException("primaryCriterionColumn null");
                        }
                        Persistent o = c.firstWhereEq((Object)value);
                        if (o == null) break block13;
                        it.setTroid(o.troid());
                    }
                }
                it.setMethod(parts[2]);
            }
        }
        return it;
    }

    public String getDB_NAME() {
        return DB_NAME;
    }

    public String getSTATIC_ROOT() {
        return STATIC_ROOT;
    }

    private String getPathInfo(Melati melati) {
        String initParameterPathInfo = this.getInitParameter("pathinfo");
        String pathInfo = melati.getRequest().getPathInfo();
        if (initParameterPathInfo == null) {
            return pathInfo == null ? "" : pathInfo;
        }
        return initParameterPathInfo + (pathInfo == null ? "" : pathInfo);
    }
}

