/*
 * Decompiled with CFR 0.152.
 */
package org.paneris.melati.site.model;

import org.melati.poem.Database;
import org.melati.poem.DefinitionSource;
import org.melati.poem.PoemException;
import org.paneris.melati.site.model.Page;
import org.paneris.melati.site.model.SiteDatabaseTables;
import org.paneris.melati.site.model.Template;
import org.paneris.melati.site.model.generated.PageTableBase;

public class PageTable<T extends Page>
extends PageTableBase<Page> {
    static int displayOrder = 0;

    public PageTable(Database database, String name, DefinitionSource definitionSource) throws PoemException {
        super(database, name, definitionSource);
    }

    public Page ensurePage(String displayName) {
        String name = PageTable.deSpace(displayName);
        Page p = (Page)this.getNameColumn().firstWhereEq((Object)name);
        if (p == null) {
            p = (Page)this.newPersistent();
            p.setName(name);
            p.setDisplayname(displayName);
            p.setDisplayorder(displayOrder);
            p.setDeleted(false);
            p.setDisplay(true);
            ++displayOrder;
            p.makePersistent();
        }
        return p;
    }

    public Page ensure(String displayName) {
        Page p = this.ensurePage(displayName);
        SiteDatabaseTables db = (SiteDatabaseTables)this.getDatabase();
        db.getDivTable().ensure(p);
        return p;
    }

    public Page ensure(String displayName, Template template) {
        Page p = this.ensurePage(displayName);
        SiteDatabaseTables db = (SiteDatabaseTables)this.getDatabase();
        db.getDivTable().ensure(p);
        p.setTemplate(template);
        return p;
    }

    public Page ensure(String displayName, Page parent) {
        Page p = this.ensure(displayName);
        p.setParent(parent);
        return p;
    }

    public Page ensure(String displayName, Page parent, String divSubject, String divContent) {
        Page p = this.ensurePage(displayName);
        p.setParent(parent);
        ((SiteDatabaseTables)this.getDatabase()).getDivTable().ensure(p, divSubject, divContent);
        return p;
    }

    public static String deSpace(String s) {
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (c != ' ') continue;
            StringBuffer t = new StringBuffer(l - 1);
            for (int j = 0; j < i; ++j) {
                t.append(s.charAt(j));
            }
            ++i;
            while (i < l) {
                c = s.charAt(i);
                if (c != ' ') {
                    t.append(c);
                }
                ++i;
            }
            return t.toString();
        }
        return s;
    }
}

